/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.cassandra.bridge.AbstractCassandraTypes;
import org.apache.cassandra.bridge.BridgeInitializationParameters;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerStandard;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.SimpleSnitch;
import org.apache.cassandra.security.EncryptionContext;

public class CassandraTypesImplementation
extends AbstractCassandraTypes {
    public static final CassandraTypesImplementation INSTANCE = new CassandraTypesImplementation();

    public static synchronized void setup(BridgeInitializationParameters params) {
        if (!setup) {
            Path tempDirectory;
            System.setProperty("org.apache.cassandra.disable_mbean_registration", "true");
            Config.setClientMode((boolean)true);
            DatabaseDescriptor.setPartitionerUnsafe((IPartitioner)Murmur3Partitioner.instance);
            DatabaseDescriptor.clientInitialization();
            Config config = DatabaseDescriptor.getRawConfig();
            config.memtable_flush_writers = 8;
            config.diagnostic_events_enabled = false;
            config.max_mutation_size_in_kb = config.commitlog_segment_size_in_mb * 1024 / 2;
            config.concurrent_compactors = 4;
            try {
                tempDirectory = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            config.data_file_directories = new String[]{tempDirectory.toString()};
            CassandraTypesImplementation.setupCommitLogConfigs(tempDirectory);
            DatabaseDescriptor.setEndpointSnitch((IEndpointSnitch)new SimpleSnitch());
            Keyspace.setInitialized();
            setup = true;
        }
    }

    protected static void setupCommitLogConfigs(Path path) {
        Path commitLogPath = path.resolve("commitlog");
        DatabaseDescriptor.getRawConfig().commitlog_directory = commitLogPath.toString();
        DatabaseDescriptor.getRawConfig().hints_directory = path.resolve("hints").toString();
        DatabaseDescriptor.getRawConfig().saved_caches_directory = path.resolve("saved_caches").toString();
        DatabaseDescriptor.setCommitLogSync((Config.CommitLogSync)Config.CommitLogSync.periodic);
        DatabaseDescriptor.setEncryptionContext((EncryptionContext)new EncryptionContext());
        DatabaseDescriptor.setCommitLogSyncPeriod((int)30);
        DatabaseDescriptor.setCommitLogMaxCompressionBuffersPerPool((int)3);
        DatabaseDescriptor.setCommitLogSyncGroupWindow((double)30.0);
        DatabaseDescriptor.setCommitLogSegmentSize((int)32);
        DatabaseDescriptor.getRawConfig().commitlog_total_space_in_mb = 1024;
        DatabaseDescriptor.setCommitLogSegmentMgrProvider(commitLog -> new CommitLogSegmentManagerStandard(commitLog, commitLogPath.toString()));
    }
}

