/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.bridge.CassandraTypesImplementation;
import org.apache.cassandra.bridge.SchemaBridge;
import org.apache.cassandra.bridge.SchemaUpdater;
import org.apache.cassandra.cdc.api.TableIdLookup;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.cql3.statements.schema.CreateTypeStatement;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.SchemaBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSchema.class);

    private CassandraSchema() {
        throw new IllegalStateException("Do not instantiate!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Consumer<Schema> updater) {
        Schema schema = Schema.instance;
        synchronized (schema) {
            updater.accept(Schema.instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T apply(Function<Schema, T> updater) {
        Schema schema = Schema.instance;
        synchronized (schema) {
            return updater.apply(Schema.instance);
        }
    }

    public static Types buildTypes(String keyspace, Set<String> udtStmts) {
        ArrayList<CreateTypeStatement.Raw> typeStatements = new ArrayList<CreateTypeStatement.Raw>(udtStmts.size());
        for (String udt : udtStmts) {
            try {
                typeStatements.add((CreateTypeStatement.Raw)CQLFragmentParser.parseAnyUnhandled(CqlParser::query, (String)udt));
            }
            catch (RecognitionException e) {
                LOGGER.error("Failed to parse type expression '{}'", (Object)udt);
                throw new IllegalStateException(e);
            }
        }
        Types.RawBuilder typesBuilder = Types.rawBuilder((String)keyspace);
        for (CreateTypeStatement.Raw st : typeStatements) {
            st.addToRawBuilder(typesBuilder);
        }
        return typesBuilder.build();
    }

    public static TableMetadata buildTableMetadata(String keyspace, String createStmt, Types types, Partitioner partitioner, @Nullable UUID tableId, boolean enableCdc) {
        TableMetadata.Builder builder = ((CreateTableStatement.Raw)CQLFragmentParser.parseAny(CqlParser::createTableStatement, (String)createStmt, (String)"CREATE TABLE")).keyspace(keyspace).prepare(null).builder(types).partitioner(CassandraTypesImplementation.getPartitioner(partitioner));
        if (tableId != null) {
            builder.id(TableId.fromUUID((UUID)tableId));
        }
        TableMetadata tableMetadata = builder.build();
        if (tableMetadata.params.cdc == enableCdc) {
            return tableMetadata;
        }
        return tableMetadata.unbuild().params(tableMetadata.params.unbuild().cdc(enableCdc).build()).build();
    }

    public static boolean keyspaceExists(Schema schema, String keyspace) {
        return CassandraSchema.getKeyspace(schema, keyspace).isPresent();
    }

    public static boolean tableExists(Schema schema, String keyspace, String table) {
        return CassandraSchema.getTable(schema, keyspace, table).isPresent();
    }

    public static Optional<Keyspace> getKeyspace(Schema schema, String keyspace) {
        return Optional.ofNullable(schema.getKeyspaceInstance(keyspace));
    }

    public static Optional<KeyspaceMetadata> getKeyspaceMetadata(Schema schema, String keyspace) {
        return CassandraSchema.getKeyspace(schema, keyspace).map(Keyspace::getMetadata);
    }

    public static Optional<TableMetadata> getTable(String keyspace, String table) {
        return CassandraSchema.getTable(Schema.instance, keyspace, table);
    }

    public static Optional<TableMetadata> getTable(Schema schema, String keyspace, String table) {
        return Optional.ofNullable(schema.getTableMetadata(keyspace, table));
    }

    public static boolean has(Schema schema, CqlTable cqlTable) {
        return CassandraSchema.has(schema, cqlTable.keyspace(), cqlTable.table());
    }

    public static boolean has(Schema schema, String keyspace, String table) {
        return CassandraSchema.keyspaceExists(schema, keyspace) && CassandraSchema.tableExists(schema, keyspace, table);
    }

    public static boolean isCdcEnabled(Schema schema, CqlTable cqlTable) {
        return CassandraSchema.isCdcEnabled(schema, cqlTable.keyspace(), cqlTable.table());
    }

    public static boolean isCdcEnabled(String keyspace, String table) {
        return CassandraSchema.isCdcEnabled(Schema.instance, keyspace, table);
    }

    public static boolean isCdcEnabled(Schema schema, String keyspace, String table) {
        KeyspaceMetadata ks = schema.getKeyspaceMetadata(keyspace);
        if (ks == null) {
            return false;
        }
        TableMetadata tb = ks.getTableOrViewNullable(table);
        return tb != null && tb.params.cdc;
    }

    public static Map<String, Set<String>> cdcEnabledTables(Schema schema) {
        return new SchemaBridge(schema).getKeyspaces().stream().collect(Collectors.toMap(Function.identity(), keyspace -> CassandraSchema.cdcEnabledTables(schema, keyspace)));
    }

    public static Set<String> cdcEnabledTables(Schema schema, String keyspace) {
        return Objects.requireNonNull(schema.getKeyspaceMetadata((String)keyspace)).tables.stream().filter(t -> t.params.cdc).map(f -> f.name).collect(Collectors.toSet());
    }

    public static void updateCdcSchema(@NotNull Set<CqlTable> cdcTables, @NotNull Partitioner partitioner, @NotNull TableIdLookup tableIdLookup) {
        CassandraSchema.updateCdcSchema(Schema.instance, cdcTables, partitioner, tableIdLookup);
    }

    public static void maybeUpdateSchema(Schema schema, Partitioner partitioner, CqlTable cqlTable, @Nullable UUID tableId, boolean enableCdc) {
        String table;
        String keyspace = cqlTable.keyspace();
        Optional<TableMetadata> currTable = CassandraSchema.getTable(schema, keyspace, table = cqlTable.table());
        if (!currTable.isPresent()) {
            throw CassandraSchema.notExistThrowable(keyspace, table);
        }
        Set<String> udts = cqlTable.udts().stream().map(f -> f.createStatement((CassandraTypes)CassandraTypesImplementation.INSTANCE, keyspace)).collect(Collectors.toSet());
        TableMetadata updatedTable = CassandraSchema.buildTableMetadata(keyspace, cqlTable.createStatement(), CassandraSchema.buildTypes(keyspace, udts), partitioner, tableId != null ? tableId : currTable.get().id.asUUID(), enableCdc);
        if (updatedTable.equals((Object)currTable.get())) {
            return;
        }
        CassandraSchema.update(s -> {
            Optional<KeyspaceMetadata> ks = CassandraSchema.getKeyspaceMetadata(s, keyspace);
            Optional<TableMetadata> tableOpt = CassandraSchema.getTable(s, keyspace, table);
            if (!ks.isPresent() || !tableOpt.isPresent()) {
                throw CassandraSchema.notExistThrowable(keyspace, table);
            }
            if (updatedTable.equals((Object)tableOpt.get())) {
                return;
            }
            LOGGER.info("Schema change detected, updating new table schema keyspace={} table={}", (Object)keyspace, (Object)cqlTable.table());
            SchemaUpdater.updateTable(s, ks.get(), updatedTable);
        });
    }

    public static void updateCdcSchema(@NotNull Schema schema, @NotNull Set<CqlTable> cdcTables, @NotNull Partitioner partitioner, @NotNull TableIdLookup tableIdLookup) {
        LOGGER.info("Updating CDC schema tables='{}'", (Object)cdcTables.stream().map(t -> String.format("%s.%s", t.keyspace(), t.table())).collect(Collectors.joining(",")));
        Map<String, Set<String>> cdcEnabledTables = CassandraSchema.cdcEnabledTables(schema);
        for (CqlTable table : cdcTables) {
            table.udts().forEach(udt -> CassandraTypesImplementation.INSTANCE.updateUDTs(table.keyspace(), (CqlField.CqlUdt)udt));
            UUID tableId = tableIdLookup.lookup(table.keyspace(), table.table());
            if (cdcEnabledTables.containsKey(table.keyspace()) && cdcEnabledTables.get(table.keyspace()).contains(table.table())) {
                LOGGER.info("CDC already enabled keyspace={} table={}", (Object)table.keyspace(), (Object)table.table());
                cdcEnabledTables.get(table.keyspace()).remove(table.table());
                CassandraSchema.maybeUpdateSchema(schema, partitioner, table, tableId, true);
                Preconditions.checkArgument((boolean)CassandraSchema.isCdcEnabled(schema, table), (Object)("CDC not enabled for table: " + table.keyspace() + "." + table.table()));
                continue;
            }
            if (CassandraSchema.has(schema, table)) {
                LOGGER.info("Enabling CDC on existing table keyspace={} table={}", (Object)table.keyspace(), (Object)table.table());
                CassandraSchema.maybeUpdateSchema(schema, partitioner, table, tableId, true);
                Preconditions.checkArgument((boolean)CassandraSchema.isCdcEnabled(schema, table), (Object)("CDC not enabled for table: " + table.keyspace() + "." + table.table()));
                continue;
            }
            LOGGER.info("Adding new CDC enabled table keyspace={} table={}", (Object)table.keyspace(), (Object)table.table());
            new SchemaBuilder(table, partitioner, tableId, true);
            if (tableId == null) continue;
            TableId tableIdAfter = TableId.fromUUID((UUID)tableId);
            Preconditions.checkNotNull((Object)schema.getTableMetadata(tableIdAfter), (Object)"Table not initialized in the schema");
            Preconditions.checkArgument((boolean)Objects.requireNonNull(schema.getKeyspaceInstance(table.keyspace())).hasColumnFamilyStore(tableIdAfter), (Object)"ColumnFamilyStore not initialized in the schema");
            Preconditions.checkArgument((boolean)CassandraSchema.isCdcEnabled(schema, table), (Object)("CDC not enabled for table: " + table.keyspace() + "." + table.table()));
        }
        cdcEnabledTables.forEach((ks, tables) -> tables.forEach(table -> {
            LOGGER.warn("Disabling CDC on table keyspace={} table={}", ks, table);
            CassandraSchema.disableCdc(schema, ks, table);
        }));
    }

    public static void enableCdc(Schema schema, CqlTable cqlTable) {
        CassandraSchema.enableCdc(schema, cqlTable.keyspace(), cqlTable.table());
    }

    public static void enableCdc(Schema schema, String keyspace, String table) {
        CassandraSchema.updateCdc(schema, keyspace, table, true);
    }

    public static void disableCdc(Schema schema, CqlTable cqlTable) {
        CassandraSchema.disableCdc(schema, cqlTable.keyspace(), cqlTable.table());
    }

    public static void disableCdc(Schema schema, String keyspace, String table) {
        CassandraSchema.updateCdc(schema, keyspace, table, false);
    }

    public static void updateCdc(Schema schema, String keyspace, String table, boolean enableCdc) {
        if (!CassandraSchema.has(schema, keyspace, table)) {
            throw new IllegalArgumentException("Keyspace/table not initialized: " + keyspace + "/" + table);
        }
        Optional<TableMetadata> tb = CassandraSchema.getTable(schema, keyspace, table);
        if (!tb.isPresent()) {
            throw CassandraSchema.notExistThrowable(keyspace, table);
        }
        if (tb.get().params.cdc == enableCdc) {
            return;
        }
        CassandraSchema.update(s -> {
            Optional<KeyspaceMetadata> ks = CassandraSchema.getKeyspaceMetadata(s, keyspace);
            Optional<TableMetadata> tableOpt = CassandraSchema.getTable(s, keyspace, table);
            if (!ks.isPresent() || !tableOpt.isPresent()) {
                throw CassandraSchema.notExistThrowable(keyspace, table);
            }
            if (tableOpt.get().params.cdc == enableCdc) {
                return;
            }
            TableMetadata updatedTable = tableOpt.get().unbuild().params(tableOpt.get().params.unbuild().cdc(enableCdc).build()).build();
            LOGGER.info("{} CDC for table keyspace={} table={}", new Object[]{updatedTable.params.cdc ? "Enabling" : "Disabling", keyspace, table});
            SchemaUpdater.updateTable(s, ks.get(), updatedTable);
        });
    }

    private static IllegalStateException notExistThrowable(String keyspace, String table) {
        return new IllegalStateException("Keyspace/table doesn't exist: " + keyspace + "/" + table);
    }
}

