/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.function.Supplier;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.spark.utils.Throwing;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.jetbrains.annotations.NotNull;

public class KeyStoreValidation
implements StartupValidation {
    private final boolean configured;
    private final String type;
    private final char[] password;
    private final Supplier<InputStream> stream;

    public KeyStoreValidation(@NotNull SecretsProvider secrets) {
        this(secrets.hasKeyStoreSecrets(), secrets.keyStoreType(), secrets.keyStorePassword(), Throwing.supplier(() -> ((SecretsProvider)secrets).keyStoreInputStream()));
    }

    protected KeyStoreValidation(boolean configured, String type, char[] password, Supplier<InputStream> stream) {
        this.configured = configured;
        this.type = type;
        this.password = password;
        this.stream = stream;
    }

    @Override
    public void validate() {
        String latestAlias = null;
        try {
            if (!this.configured) {
                return;
            }
            if (this.password == null) {
                throw new RuntimeException("Keystore password was not provided.");
            }
            KeyStore keyStore = KeyStore.getInstance(this.type);
            keyStore.load(this.stream.get(), this.password);
            if (keyStore.size() == 0) {
                throw new RuntimeException("KeyStore is empty");
            }
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                latestAlias = aliases.nextElement();
                Certificate cert = keyStore.getCertificate(latestAlias);
                if (!(cert instanceof X509Certificate)) continue;
                ((X509Certificate)cert).checkValidity();
            }
            aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Key key = keyStore.getKey(aliases.nextElement(), this.password);
                if (key == null || !(key instanceof PrivateKey)) continue;
                return;
            }
            throw new RuntimeException("KeyStore contains no private keys");
        }
        catch (CertificateExpiredException exception) {
            throw new RuntimeException(String.format("Certificate with alias '%s' is expired.", latestAlias), exception);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeException("KeyStore is misconfigured", exception);
        }
    }
}

