/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types.complex;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;

public class SparkUdt
implements SparkType {
    private final SparkSqlTypeConverter converter;
    private final CqlField.CqlUdt udt;
    private final List<SparkType> sparkTypes;

    public SparkUdt(SparkSqlTypeConverter converter, CqlField.CqlUdt udt) {
        this.converter = converter;
        this.udt = udt;
        this.sparkTypes = udt.fields().stream().map(CqlField::type).map(converter::toSparkType).collect(Collectors.toList());
    }

    public CqlField field(int position) {
        return this.udt.field(position);
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.createStructType((StructField[])((StructField[])this.udt.fields().stream().map(field -> DataTypes.createStructField((String)field.name(), (DataType)this.converter.sparkSqlType(field.type(), bigNumberConfig), (boolean)true)).toArray(StructField[]::new)));
    }

    @Override
    public Object sparkSqlRowValue(GenericInternalRow row, int position) {
        InternalRow struct = row.getStruct(position, this.size());
        return IntStream.range(0, this.size()).boxed().collect(Collectors.toMap(index -> this.field((int)index).name(), index -> this.sparkType((int)index).toTestRowType(struct.get(index.intValue(), this.sparkType((int)index).dataType()))));
    }

    @Override
    public Object sparkSqlRowValue(Row row, int position) {
        Row struct = row.getStruct(position);
        return IntStream.range(0, struct.size()).boxed().filter(index -> !struct.isNullAt(index.intValue())).collect(Collectors.toMap(index -> struct.schema().fields()[index].name(), index -> this.sparkType((int)index).toTestRowType(struct.get(index.intValue()))));
    }

    public List<SparkType> sparkTypes() {
        return this.sparkTypes;
    }

    public int size() {
        return this.udt.fields().size();
    }

    public SparkType sparkType() {
        return this.sparkType(0);
    }

    public SparkType sparkType(int position) {
        return this.sparkTypes().get(position);
    }

    @Override
    public int compareTo(Object first, Object second) {
        return SparkType.compareArrays(((GenericInternalRow)first).values(), ((GenericInternalRow)second).values(), this::sparkType);
    }

    @Override
    public boolean equals(Object first, Object second) {
        return SparkType.equalsArrays(((GenericInternalRow)first).values(), ((GenericInternalRow)second).values(), this::sparkType);
    }

    @Override
    public Object toTestRowType(Object value) {
        GenericRowWithSchema row = (GenericRowWithSchema)value;
        String[] fieldNames = row.schema().fieldNames();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(fieldNames.length);
        for (int index = 0; index < fieldNames.length; ++index) {
            result.put(fieldNames[index], this.sparkType(index).toTestRowType(row.get(index)));
        }
        return result;
    }

    @Override
    public Object toSparkSqlType(Object value, boolean isFrozen) {
        return this.udtToSparkSqlType(value, isFrozen);
    }

    private GenericInternalRow udtToSparkSqlType(Object value, boolean isFrozen) {
        if (value instanceof ByteBuffer) {
            return this.udtToSparkSqlType(this.udt.deserializeUdt((TypeConverter)this.converter, (ByteBuffer)value, isFrozen));
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected Map<String, Object> or raw ByteBuffer for UDT type");
        }
        Map map = (Map)value;
        return this.udtToSparkSqlType(map);
    }

    private GenericInternalRow udtToSparkSqlType(Map<String, Object> value) {
        Object[] objects = new Object[this.size()];
        for (int index = 0; index < this.size(); ++index) {
            objects[index] = value.getOrDefault(this.field(index).name(), null);
        }
        return new GenericInternalRow(objects);
    }
}

