/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.unsafe.types.UTF8String;
import org.jetbrains.annotations.NotNull;

interface StringFeatures
extends SparkType {
    @Override
    default public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return UTF8String.fromString((String)value.toString());
    }

    @Override
    default public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.getString(position);
    }

    @Override
    default public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.getString(position);
    }

    @Override
    default public Object toTestRowType(Object value) {
        if (value instanceof UTF8String) {
            return ((UTF8String)value).toString();
        }
        return value;
    }

    @Override
    default public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.StringType;
    }

    @Override
    default public boolean equalsTo(Object first, Object second) {
        return first.equals(second);
    }

    @Override
    default public int compareTo(Object first, Object second) {
        if (first instanceof String && second instanceof String) {
            return CqlField.STRING_COMPARATOR.compare(first.toString(), second.toString());
        }
        return ((UTF8String)first).compare((UTF8String)second);
    }
}

