/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.Nullable;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.MultiMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.ClientWebSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebSocketConnectOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebSocketFrame;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpClientBase;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.future.PromiseInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.SocketAddress;

public class ClientWebSocketImpl
implements ClientWebSocket {
    private HttpClientBase client;
    private final AtomicReference<Promise<WebSocket>> connect = new AtomicReference();
    private volatile WebSocket ws;
    private Handler<Throwable> exceptionHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> drainHandler;
    private Handler<WebSocketFrame> frameHandler;
    private Handler<String> textMessageHandler;
    private Handler<Buffer> binaryMessageHandler;
    private Handler<Buffer> pongHandler;

    ClientWebSocketImpl(HttpClientBase client) {
        this.client = client;
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        ContextInternal ctx = this.client.vertx().getOrCreateContext();
        PromiseInternal<WebSocket> promise = ctx.promise();
        if (!this.connect.compareAndSet(null, promise)) {
            return ctx.failedFuture("Already connecting");
        }
        this.client.webSocket(options, (Handler<AsyncResult<WebSocket>>)promise);
        return promise.future().andThen(ar -> {
            if (ar.succeeded()) {
                WebSocket w;
                this.ws = w = (WebSocket)ar.result();
                w.handler((Handler)this.dataHandler);
                w.binaryMessageHandler(this.binaryMessageHandler);
                w.textMessageHandler(this.textMessageHandler);
                w.endHandler((Handler)this.endHandler);
                w.closeHandler((Handler)this.closeHandler);
                w.exceptionHandler((Handler)this.exceptionHandler);
                w.drainHandler((Handler)this.drainHandler);
                w.frameHandler((Handler)this.frameHandler);
                w.pongHandler(this.pongHandler);
                w.resume();
            }
        });
    }

    @Override
    public void connect(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        Future<WebSocket> fut = this.connect(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public ClientWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.exceptionHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.handler((Handler)handler);
        }
        return this;
    }

    @Override
    public WebSocket pause() {
        this.delegate().pause();
        return this;
    }

    @Override
    public WebSocket resume() {
        this.delegate().resume();
        return this;
    }

    @Override
    public WebSocket fetch(long amount) {
        this.delegate().fetch(amount);
        return this;
    }

    @Override
    public ClientWebSocket endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.endHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate().setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public ClientWebSocket drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.drainHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.closeHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.frameHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.frameHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public String binaryHandlerID() {
        return this.delegate().binaryHandlerID();
    }

    @Override
    public String textHandlerID() {
        return this.delegate().textHandlerID();
    }

    @Override
    public String subProtocol() {
        return this.delegate().subProtocol();
    }

    @Override
    public Short closeStatusCode() {
        return this.delegate().closeStatusCode();
    }

    @Override
    public String closeReason() {
        return this.delegate().closeReason();
    }

    @Override
    public MultiMap headers() {
        return this.delegate().headers();
    }

    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        return this.delegate().writeFrame(frame);
    }

    @Override
    public ClientWebSocket writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate().writeFrame(frame, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        return this.delegate().writeFinalTextFrame(text);
    }

    @Override
    public ClientWebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate().writeFinalTextFrame(text, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.delegate().writeFinalBinaryFrame(data);
    }

    @Override
    public ClientWebSocket writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate().writeFinalBinaryFrame(data, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.delegate().writeBinaryMessage(data);
    }

    @Override
    public ClientWebSocket writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate().writeBinaryMessage(data, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        return this.delegate().writeTextMessage(text);
    }

    @Override
    public ClientWebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate().writeTextMessage(text, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        return this.delegate().writePing(data);
    }

    @Override
    public ClientWebSocket writePing(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate().writePing(data, (Handler)handler);
        return this;
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        return this.delegate().writePong(data);
    }

    @Override
    public ClientWebSocket writePong(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate().writePong(data, (Handler)handler);
        return this;
    }

    @Override
    public ClientWebSocket textMessageHandler(@Nullable Handler<String> handler) {
        this.textMessageHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.textMessageHandler(handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket binaryMessageHandler(@Nullable Handler<Buffer> handler) {
        this.binaryMessageHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.binaryMessageHandler(handler);
        }
        return this;
    }

    @Override
    public ClientWebSocket pongHandler(@Nullable Handler<Buffer> handler) {
        this.pongHandler = handler;
        WebSocket w = this.ws;
        if (w != null) {
            w.pongHandler(handler);
        }
        return this;
    }

    @Override
    public Future<Void> end() {
        return this.delegate().end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate().end(handler);
    }

    @Override
    public Future<Void> close() {
        return this.delegate().close();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate().close(handler);
    }

    @Override
    public Future<Void> close(short statusCode) {
        return this.delegate().close(statusCode);
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate().close(statusCode, handler);
    }

    @Override
    public Future<Void> close(short statusCode, @Nullable String reason) {
        return this.delegate().close(statusCode, reason);
    }

    @Override
    public void close(short statusCode, @Nullable String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate().close(statusCode, reason, handler);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.delegate().remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.delegate().localAddress();
    }

    @Override
    public boolean isSsl() {
        return this.delegate().isSsl();
    }

    @Override
    public boolean isClosed() {
        return this.delegate().isClosed();
    }

    @Override
    public SSLSession sslSession() {
        return this.delegate().sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate().peerCertificateChain();
    }

    @Override
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.delegate().peerCertificates();
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.delegate().write(data);
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate().write(data, handler);
    }

    @Override
    public boolean writeQueueFull() {
        return this.delegate().writeQueueFull();
    }

    private WebSocket delegate() {
        WebSocket w = this.ws;
        if (w == null) {
            throw new IllegalStateException("Not connected");
        }
        return w;
    }
}

