/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.gridkit.jvmtool.gcmon.MemoryInfoEventPojo;
import org.gridkit.jvmtool.gcmon.MemoryPoolEventConsumer;
import org.gridkit.jvmtool.gcmon.MemoryUsageBean;

public class MemoryPoolPoller {
    private Map<String, MemPoolTracker> trackers = new HashMap<String, MemPoolTracker>();
    private MemoryPoolEventConsumer consumer;

    public MemoryPoolPoller(MBeanServerConnection mserver, MemoryPoolEventConsumer consumer) {
        this.consumer = consumer;
        try {
            ObjectName name = new ObjectName("java.lang:type=MemoryPool,name=*");
            for (ObjectName on : mserver.queryNames(name, null)) {
                MemoryPoolMXBean mpool = JMX.newMXBeanProxy(mserver, on, MemoryPoolMXBean.class);
                MemPoolTracker tracker = this.init(mpool);
                this.trackers.put(tracker.poolName, tracker);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void poll() {
        for (MemPoolTracker t2 : this.trackers.values()) {
            this.poll(t2);
        }
    }

    private MemPoolTracker init(MemoryPoolMXBean mpool) {
        MemPoolTracker tracker = new MemPoolTracker();
        tracker.poolName = mpool.getName();
        tracker.poolBean = mpool;
        tracker.nonHeap = mpool.getType() != MemoryType.HEAP;
        this.poll(tracker);
        return tracker;
    }

    private void poll(MemPoolTracker tracker) {
        MemoryUsageBean bcollectionUsage;
        MemoryUsage usage = tracker.poolBean.getUsage();
        MemoryUsage peakUsage = tracker.poolBean.getPeakUsage();
        MemoryUsage collectionUsage = tracker.poolBean.getCollectionUsage();
        long ts = System.currentTimeMillis();
        MemoryUsageBean busage = usage == null ? null : new MemoryUsageBean(usage);
        MemoryUsageBean bpeakUsage = peakUsage == null ? null : new MemoryUsageBean(peakUsage);
        MemoryUsageBean memoryUsageBean = bcollectionUsage = collectionUsage == null ? null : new MemoryUsageBean(collectionUsage);
        if (busage != null && !busage.equals(tracker.lastMemUsage)) {
            tracker.lastMemUsage = busage;
            this.fireUsageEvent(ts, tracker);
        }
        if (bpeakUsage != null && !bpeakUsage.equals(tracker.lastMemPeak)) {
            tracker.lastMemPeak = bpeakUsage;
            this.firePeakUsageEvent(ts, tracker);
        }
        if (bcollectionUsage != null && !bcollectionUsage.equals(tracker.lastMemCollection)) {
            tracker.lastMemCollection = bcollectionUsage;
            this.fireCollectionUsageEvent(ts, tracker);
        }
    }

    private void fireUsageEvent(long timestamp, MemPoolTracker tracker) {
        MemoryInfoEventPojo pojo = new MemoryInfoEventPojo();
        pojo.timestamp(System.currentTimeMillis());
        pojo.name(tracker.poolName);
        pojo.nonHeap(tracker.nonHeap);
        pojo.currentUsage(tracker.lastMemUsage);
        this.consumer.consumeUsageEvent(pojo);
    }

    private void firePeakUsageEvent(long timestamp, MemPoolTracker tracker) {
        MemoryInfoEventPojo pojo = new MemoryInfoEventPojo();
        pojo.timestamp(System.currentTimeMillis());
        pojo.name(tracker.poolName);
        pojo.nonHeap(tracker.nonHeap);
        pojo.peakUsage(tracker.lastMemPeak);
        this.consumer.consumePeakEvent(pojo);
    }

    private void fireCollectionUsageEvent(long timestamp, MemPoolTracker tracker) {
        MemoryInfoEventPojo pojo = new MemoryInfoEventPojo();
        pojo.timestamp(System.currentTimeMillis());
        pojo.name(tracker.poolName);
        pojo.nonHeap(tracker.nonHeap);
        pojo.collectionUsage(tracker.lastMemCollection);
        this.consumer.consumeCollectionUsageEvent(pojo);
    }

    private class MemPoolTracker {
        MemoryPoolMXBean poolBean;
        String poolName;
        boolean nonHeap;
        MemoryUsageBean lastMemUsage;
        MemoryUsageBean lastMemPeak;
        MemoryUsageBean lastMemCollection;

        private MemPoolTracker() {
        }
    }
}

