/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pattern.PatternTypingFilter;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class PatternTypingFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "patternTyping";
    private final String patternFile;
    private PatternTypingFilter.PatternTypingRule[] rules;

    public PatternTypingFilterFactory(Map<String, String> args) {
        super(args);
        this.patternFile = this.require(args, "patternFile");
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public PatternTypingFilterFactory() {
        throw PatternTypingFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        ArrayList<PatternTypingFilter.PatternTypingRule> ruleList = new ArrayList<PatternTypingFilter.PatternTypingRule>();
        List<String> lines = this.getLines(loader, this.patternFile);
        for (String line : lines) {
            int firstSpace = line.indexOf(" ");
            int flagsVal = Integer.parseInt(line.substring(0, firstSpace));
            String[] split = (line = line.substring(firstSpace + 1)).split(" ::: ");
            if (split.length != 2) {
                throw new RuntimeException("The PatternTypingFilter: Always two there are, no more, no less, a pattern and a replacement (separated by ' ::: ' )");
            }
            Pattern compiled = Pattern.compile(split[0]);
            ruleList.add(new PatternTypingFilter.PatternTypingRule(compiled, flagsVal, split[1]));
        }
        this.rules = ruleList.toArray(new PatternTypingFilter.PatternTypingRule[0]);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new PatternTypingFilter(input, this.rules);
    }
}

