/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.utils.Architecture;
import org.apache.cassandra.utils.memory.MemoryUtil;

public class LittleEndianMemoryUtil
extends MemoryUtil {
    public static int getUnsignedShort(long address) {
        if (Architecture.IS_UNALIGNED || (address & 1L) == 0L) {
            return (Architecture.BIG_ENDIAN ? Short.reverseBytes(unsafe.getShort(address)) : unsafe.getShort(address)) & 0xFFFF;
        }
        return LittleEndianMemoryUtil.getShortByByte(address) & 0xFFFF;
    }

    public static int getInt(long address) {
        if (Architecture.IS_UNALIGNED || (address & 3L) == 0L) {
            return Architecture.BIG_ENDIAN ? Integer.reverseBytes(unsafe.getInt(address)) : unsafe.getInt(address);
        }
        return LittleEndianMemoryUtil.getIntByByte(address);
    }

    public static long getLong(long address) {
        if (Architecture.IS_UNALIGNED || (address & 7L) == 0L) {
            return Architecture.BIG_ENDIAN ? Long.reverseBytes(unsafe.getLong(address)) : unsafe.getLong(address);
        }
        return LittleEndianMemoryUtil.getLongByByte(address);
    }

    public static void setShort(long address, short s2) {
        if (Architecture.IS_UNALIGNED || (address & 1L) == 0L) {
            unsafe.putShort(address, Architecture.BIG_ENDIAN ? Short.reverseBytes(s2) : s2);
        } else {
            LittleEndianMemoryUtil.putShortByByte(address, s2);
        }
    }

    public static void setInt(long address, int l) {
        if (Architecture.IS_UNALIGNED || (address & 3L) == 0L) {
            unsafe.putInt(address, Architecture.BIG_ENDIAN ? Integer.reverseBytes(l) : l);
        } else {
            LittleEndianMemoryUtil.putIntByByte(address, l);
        }
    }

    public static void setLong(long address, long l) {
        if (Architecture.IS_UNALIGNED || (address & 7L) == 0L) {
            unsafe.putLong(address, Architecture.BIG_ENDIAN ? Long.reverseBytes(l) : l);
        } else {
            LittleEndianMemoryUtil.putLongByByte(address, l);
        }
    }

    @VisibleForTesting
    static long getLongByByte(long address) {
        return (long)unsafe.getByte(address + 7L) << 56 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 8 | (long)unsafe.getByte(address) & 0xFFL;
    }

    @VisibleForTesting
    static int getIntByByte(long address) {
        return unsafe.getByte(address + 3L) << 24 | (unsafe.getByte(address + 2L) & 0xFF) << 16 | (unsafe.getByte(address + 1L) & 0xFF) << 8 | unsafe.getByte(address) & 0xFF;
    }

    @VisibleForTesting
    static int getShortByByte(long address) {
        return unsafe.getByte(address + 1L) << 8 | unsafe.getByte(address) & 0xFF;
    }

    @VisibleForTesting
    static void putLongByByte(long address, long value) {
        unsafe.putByte(address + 7L, (byte)(value >> 56));
        unsafe.putByte(address + 6L, (byte)(value >> 48));
        unsafe.putByte(address + 5L, (byte)(value >> 40));
        unsafe.putByte(address + 4L, (byte)(value >> 32));
        unsafe.putByte(address + 3L, (byte)(value >> 24));
        unsafe.putByte(address + 2L, (byte)(value >> 16));
        unsafe.putByte(address + 1L, (byte)(value >> 8));
        unsafe.putByte(address, (byte)value);
    }

    @VisibleForTesting
    static void putIntByByte(long address, int value) {
        unsafe.putByte(address + 3L, (byte)(value >> 24));
        unsafe.putByte(address + 2L, (byte)(value >> 16));
        unsafe.putByte(address + 1L, (byte)(value >> 8));
        unsafe.putByte(address, (byte)value);
    }

    @VisibleForTesting
    static void putShortByByte(long address, short value) {
        unsafe.putByte(address + 1L, (byte)(value >> 8));
        unsafe.putByte(address, (byte)value);
    }

    public static ByteBuffer getByteBuffer(long address, int length) {
        return LittleEndianMemoryUtil.getByteBuffer(address, length, ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer getHollowDirectByteBuffer() {
        return LittleEndianMemoryUtil.getHollowDirectByteBuffer(ByteOrder.LITTLE_ENDIAN);
    }
}

