/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.ViewMetadata;

public final class Views
implements Iterable<ViewMetadata> {
    private static final Views NONE = Views.builder().build();
    private final ImmutableMap<String, ViewMetadata> views;

    private Views(Builder builder) {
        this.views = ImmutableMap.copyOf(builder.views);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder unbuild() {
        return Views.builder().put(this);
    }

    public static Views none() {
        return NONE;
    }

    @Override
    public Iterator<ViewMetadata> iterator() {
        return ((ImmutableCollection)this.views.values()).iterator();
    }

    Iterable<TableMetadata> allTableMetadata() {
        return Iterables.transform(this.views.values(), view -> view.metadata);
    }

    public int size() {
        return this.views.size();
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    public Iterable<ViewMetadata> forTable(TableId tableId) {
        return Iterables.filter(this, v -> v.baseTableId.equals(tableId));
    }

    public Stream<ViewMetadata> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<ViewMetadata> stream(TableId tableId) {
        return this.stream().filter((? super T v) -> v.baseTableId.equals(tableId));
    }

    public Optional<ViewMetadata> get(String name) {
        return Optional.ofNullable(this.views.get(name));
    }

    @Nullable
    public ViewMetadata getNullable(String name) {
        return this.views.get(name);
    }

    boolean containsView(String name) {
        return this.views.containsKey(name);
    }

    Views filter(Predicate<ViewMetadata> predicate) {
        Builder builder = Views.builder();
        this.views.values().stream().filter(predicate).forEach(builder::put);
        return builder.build();
    }

    public Views with(ViewMetadata view) {
        if (this.get(view.name()).isPresent()) {
            throw new IllegalStateException(String.format("Materialized View %s already exists", view.name()));
        }
        return Views.builder().put(this).put(view).build();
    }

    public Views withSwapped(ViewMetadata view) {
        return this.without(view.name()).with(view);
    }

    public Views without(String name) {
        ViewMetadata materializedView = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Materialized View %s doesn't exists", name)));
        return this.filter(v -> v != materializedView);
    }

    Views withUpdatedUserTypes(UserType udt) {
        return Iterables.any(this, v -> v.referencesUserType(udt.name)) ? Views.builder().put(Iterables.transform(this, v -> v.withUpdatedUserType(udt))).build() : this;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Views && this.views.equals(((Views)o).views);
    }

    public int hashCode() {
        return this.views.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.views.values()).toString();
    }

    static ViewsDiff diff(Views before, Views after) {
        return ViewsDiff.diff(before, after);
    }

    static final class ViewsDiff
    extends Diff<Views, ViewMetadata> {
        private static final ViewsDiff NONE = new ViewsDiff(Views.none(), Views.none(), (ImmutableCollection<Diff.Altered<ViewMetadata>>)ImmutableList.of());

        private ViewsDiff(Views created, Views dropped, ImmutableCollection<Diff.Altered<ViewMetadata>> altered) {
            super(created, dropped, altered);
        }

        private static ViewsDiff diff(Views before, Views after) {
            if (before == after) {
                return NONE;
            }
            Views created = after.filter(v -> !before.containsView(v.name()));
            Views dropped = before.filter(v -> !after.containsView(v.name()));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.forEach(viewBefore -> {
                ViewMetadata viewAfter = after.getNullable(viewBefore.name());
                if (null != viewAfter) {
                    viewBefore.compare(viewAfter).ifPresent(kind -> altered.add(new Diff.Altered<ViewMetadata>((ViewMetadata)viewBefore, viewAfter, (Difference)((Object)((Object)kind)))));
                }
            });
            return new ViewsDiff(created, dropped, altered.build());
        }
    }

    public static final class Builder {
        final Map<String, ViewMetadata> views = new HashMap<String, ViewMetadata>();

        private Builder() {
        }

        public Views build() {
            return new Views(this);
        }

        public ViewMetadata get(String name) {
            return this.views.get(name);
        }

        public Builder put(ViewMetadata view) {
            this.views.put(view.name(), view);
            return this;
        }

        public Builder remove(String name) {
            this.views.remove(name);
            return this;
        }

        public Builder put(Iterable<ViewMetadata> views) {
            views.forEach(this::put);
            return this;
        }
    }
}

