/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

public final class Tables
implements Iterable<TableMetadata> {
    private static final Tables NONE = Tables.builder().build();
    private final ImmutableMap<String, TableMetadata> tables;
    private final ImmutableMap<TableId, TableMetadata> tablesById;
    private final ImmutableMap<String, TableMetadata> indexTables;

    private Tables(Builder builder) {
        this.tables = builder.tables.build();
        this.tablesById = builder.tablesById.build();
        this.indexTables = builder.indexTables.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Tables none() {
        return NONE;
    }

    public static Tables of(TableMetadata ... tables) {
        return Tables.builder().add(tables).build();
    }

    public static Tables of(Iterable<TableMetadata> tables) {
        return Tables.builder().add(tables).build();
    }

    @Override
    public Iterator<TableMetadata> iterator() {
        return ((ImmutableCollection)this.tables.values()).iterator();
    }

    public Stream<TableMetadata> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Iterable<TableMetadata> referencingUserType(ByteBuffer name) {
        return Iterables.filter(this.tables.values(), t2 -> t2.referencesUserType(name));
    }

    ImmutableMap<String, TableMetadata> indexTables() {
        return this.indexTables;
    }

    public int size() {
        return this.tables.size();
    }

    public Optional<TableMetadata> get(String name) {
        return Optional.ofNullable(this.tables.get(name));
    }

    @Nullable
    public TableMetadata getNullable(String name) {
        return this.tables.get(name);
    }

    @Nullable
    public TableMetadata getNullable(TableId id) {
        return this.tablesById.get(id);
    }

    boolean containsTable(TableId id) {
        return this.tablesById.containsKey(id);
    }

    public Tables filter(Predicate<TableMetadata> predicate) {
        Builder builder = Tables.builder();
        this.tables.values().stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    public Tables with(TableMetadata table) {
        if (this.get(table.name).isPresent()) {
            throw new IllegalStateException(String.format("Table %s already exists", table.name));
        }
        return Tables.builder().add(this).add(table).build();
    }

    public Tables withSwapped(TableMetadata table) {
        return this.without(table.name).with(table);
    }

    public Tables without(String name) {
        TableMetadata table = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Table %s doesn't exists", name)));
        return this.without(table);
    }

    public Tables without(TableMetadata table) {
        return this.filter(t2 -> t2 != table);
    }

    public Tables withUpdatedUserType(UserType udt) {
        return Iterables.any(this, t2 -> t2.referencesUserType(udt.name)) ? Tables.builder().add(Iterables.transform(this, t2 -> t2.withUpdatedUserType(udt))).build() : this;
    }

    MapDifference<String, TableMetadata> indexesDiff(Tables other) {
        HashMap thisIndexTables = new HashMap();
        this.indexTables.values().forEach(t2 -> thisIndexTables.put(t2.indexName().get(), t2));
        HashMap otherIndexTables = new HashMap();
        other.indexTables.values().forEach(t2 -> otherIndexTables.put(t2.indexName().get(), t2));
        return Maps.difference(thisIndexTables, otherIndexTables);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Tables && this.tables.equals(((Tables)o).tables);
    }

    public int hashCode() {
        return this.tables.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.tables.values()).toString();
    }

    static TablesDiff diff(Tables before, Tables after) {
        return TablesDiff.diff(before, after);
    }

    public static final class TablesDiff
    extends Diff<Tables, TableMetadata> {
        private static final TablesDiff NONE = new TablesDiff(Tables.none(), Tables.none(), (ImmutableCollection<Diff.Altered<TableMetadata>>)ImmutableList.of());

        private TablesDiff(Tables created, Tables dropped, ImmutableCollection<Diff.Altered<TableMetadata>> altered) {
            super(created, dropped, altered);
        }

        private static TablesDiff diff(Tables before, Tables after) {
            if (before == after) {
                return NONE;
            }
            Tables created = after.filter(t2 -> !before.containsTable(t2.id));
            Tables dropped = before.filter(t2 -> !after.containsTable(t2.id));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.forEach(tableBefore -> {
                TableMetadata tableAfter = after.getNullable(tableBefore.id);
                if (null != tableAfter) {
                    tableBefore.compare(tableAfter).ifPresent(kind -> altered.add(new Diff.Altered<TableMetadata>((TableMetadata)tableBefore, tableAfter, (Difference)((Object)((Object)kind)))));
                }
            });
            return new TablesDiff(created, dropped, altered.build());
        }
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, TableMetadata> tables = new ImmutableMap.Builder();
        final ImmutableMap.Builder<TableId, TableMetadata> tablesById = new ImmutableMap.Builder();
        final ImmutableMap.Builder<String, TableMetadata> indexTables = new ImmutableMap.Builder();

        private Builder() {
        }

        public Tables build() {
            return new Tables(this);
        }

        public Builder add(TableMetadata table) {
            this.tables.put(table.name, table);
            this.tablesById.put(table.id, table);
            table.indexes.stream().filter(i -> !i.isCustom()).map(i -> CassandraIndex.indexCfsMetadata(table, i)).forEach(i -> this.indexTables.put(i.indexName().get(), (TableMetadata)i));
            return this;
        }

        public Builder add(TableMetadata ... tables) {
            for (TableMetadata table : tables) {
                this.add(table);
            }
            return this;
        }

        public Builder add(Iterable<TableMetadata> tables) {
            tables.forEach(this::add);
            return this;
        }
    }
}

