/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.repair.NoSuchRepairSessionException;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.consistent.ConsistentSession;
import org.apache.cassandra.repair.consistent.CoordinatorSession;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.FinalizePromise;
import org.apache.cassandra.repair.messages.PrepareConsistentResponse;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorSessions {
    private static final Logger logger = LoggerFactory.getLogger(CoordinatorSessions.class);
    private final SharedContext ctx;
    private final Map<TimeUUID, CoordinatorSession> sessions = new HashMap<TimeUUID, CoordinatorSession>();

    public CoordinatorSessions(SharedContext ctx) {
        this.ctx = ctx;
    }

    protected CoordinatorSession buildSession(CoordinatorSession.Builder builder) {
        return new CoordinatorSession(builder);
    }

    public synchronized CoordinatorSession registerSession(TimeUUID sessionId, Set<InetAddressAndPort> participants, boolean isForced) throws NoSuchRepairSessionException {
        ActiveRepairService.ParentRepairSession prs = this.ctx.repair().getParentRepairSession(sessionId);
        Preconditions.checkArgument(!this.sessions.containsKey(sessionId), "A coordinator already exists for session %s", (Object)sessionId);
        Preconditions.checkArgument(!isForced || prs.repairedAt == 0L, "cannot promote data for forced incremental repairs");
        CoordinatorSession.Builder builder = CoordinatorSession.builder(this.ctx);
        builder.withState(ConsistentSession.State.PREPARING);
        builder.withSessionID(sessionId);
        builder.withCoordinator(prs.coordinator);
        builder.withTableIds(prs.getTableIds());
        builder.withRepairedAt(prs.repairedAt);
        builder.withRanges(prs.getRanges());
        builder.withParticipants(participants);
        builder.withListener(this::onSessionStateUpdate);
        builder.withContext(this.ctx);
        CoordinatorSession session = this.buildSession(builder);
        this.sessions.put(session.sessionID, session);
        return session;
    }

    public synchronized CoordinatorSession getSession(TimeUUID sessionId) {
        return this.sessions.get(sessionId);
    }

    public synchronized void onSessionStateUpdate(CoordinatorSession session) {
        if (session.isCompleted()) {
            logger.info("Removing completed session {} with state {}", (Object)session.sessionID, (Object)session.getState());
            this.sessions.remove(session.sessionID);
        }
    }

    public void handlePrepareResponse(Message<? extends RepairMessage> msg) {
        PrepareConsistentResponse payload = (PrepareConsistentResponse)msg.payload;
        CoordinatorSession session = this.getSession(payload.parentSession);
        if (session != null) {
            session.handlePrepareResponse(msg);
        } else {
            RepairMessage.sendFailureResponse(this.ctx, msg);
        }
    }

    public void handleFinalizePromiseMessage(Message<? extends RepairMessage> message) {
        FinalizePromise msg = (FinalizePromise)message.payload;
        CoordinatorSession session = this.getSession(msg.sessionID);
        if (session != null) {
            session.handleFinalizePromise(message);
        } else {
            RepairMessage.sendFailureResponse(this.ctx, message);
        }
    }

    public void handleFailSessionMessage(FailSession msg) {
        CoordinatorSession session = this.getSession(msg.sessionID);
        if (session != null) {
            session.fail();
        }
    }
}

