/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.zip.CRC32;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.FrameDecoderWith8bHeader;
import org.apache.cassandra.net.ShareableBytes;

public final class FrameDecoderLZ4
extends FrameDecoderWith8bHeader {
    private static final int HEADER_LENGTH = 8;
    private static final int TRAILER_LENGTH = 4;
    private static final int HEADER_AND_TRAILER_LENGTH = 12;
    private final LZ4SafeDecompressor decompressor;

    public static FrameDecoderLZ4 fast(BufferPoolAllocator allocator) {
        return new FrameDecoderLZ4(allocator, LZ4Factory.fastestInstance().safeDecompressor());
    }

    private static int compressedLength(long header8b) {
        return (int)header8b & 0x1FFFF;
    }

    private static int uncompressedLength(long header8b) {
        return (int)(header8b >>> 17) & 0x1FFFF;
    }

    private static boolean isSelfContained(long header8b) {
        return 0L != (header8b & 0x400000000L);
    }

    private static int headerCrc(long header8b) {
        return (int)(header8b >>> 40) & 0xFFFFFF;
    }

    private FrameDecoderLZ4(BufferPoolAllocator allocator, LZ4SafeDecompressor decompressor) {
        super(allocator);
        this.decompressor = decompressor;
    }

    @Override
    final long readHeader(ByteBuffer frame, int begin) {
        long header8b = frame.getLong(begin);
        if (frame.order() == ByteOrder.BIG_ENDIAN) {
            header8b = Long.reverseBytes(header8b);
        }
        return header8b;
    }

    @Override
    final FrameDecoder.CorruptFrame verifyHeader(long header8b) {
        int computeLengthCrc = Crc.crc24(header8b, 5);
        int readLengthCrc = FrameDecoderLZ4.headerCrc(header8b);
        return readLengthCrc == computeLengthCrc ? null : FrameDecoder.CorruptFrame.unrecoverable(readLengthCrc, computeLengthCrc);
    }

    @Override
    final int frameLength(long header8b) {
        return FrameDecoderLZ4.compressedLength(header8b) + 12;
    }

    @Override
    final FrameDecoder.Frame unpackFrame(ShareableBytes bytes, int begin, int end, long header8b) {
        ByteBuffer input = bytes.get();
        boolean isSelfContained = FrameDecoderLZ4.isSelfContained(header8b);
        int uncompressedLength = FrameDecoderLZ4.uncompressedLength(header8b);
        CRC32 crc = Crc.crc32();
        int readFullCrc = input.getInt(end - 4);
        if (input.order() == ByteOrder.BIG_ENDIAN) {
            readFullCrc = Integer.reverseBytes(readFullCrc);
        }
        Crc.updateCrc32(crc, input, begin + 8, end - 4);
        int computeFullCrc = (int)crc.getValue();
        if (readFullCrc != computeFullCrc) {
            return FrameDecoder.CorruptFrame.recoverable(isSelfContained, uncompressedLength, readFullCrc, computeFullCrc);
        }
        if (uncompressedLength == 0) {
            return new FrameDecoder.IntactFrame(isSelfContained, bytes.slice(begin + 8, end - 4));
        }
        ByteBuffer out = this.allocator.get(uncompressedLength);
        try {
            int sourceLength = end - (begin + 8 + 4);
            this.decompressor.decompress(input, begin + 8, sourceLength, out, 0, uncompressedLength);
            return new FrameDecoder.IntactFrame(isSelfContained, ShareableBytes.wrap(out));
        }
        catch (Throwable t2) {
            this.allocator.put(out);
            throw t2;
        }
    }

    @Override
    void decode(Collection<FrameDecoder.Frame> into, ShareableBytes bytes) {
        this.decode(into, bytes, 8);
    }

    @Override
    void addLastTo(ChannelPipeline pipeline) {
        pipeline.addLast("frameDecoderLZ4", (ChannelHandler)this);
    }
}

