/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.apache.cassandra.net.AsyncChannelOutputPlus;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.InvalidSerializedSizeException;

public class AsyncMessageOutputPlus
extends AsyncChannelOutputPlus {
    private final int highWaterMark;
    private final int lowWaterMark;
    private final int bufferSize;
    private final int messageSize;
    private boolean closing;
    private final FrameEncoder.PayloadAllocator payloadAllocator;
    private volatile FrameEncoder.Payload payload;

    AsyncMessageOutputPlus(Channel channel, int bufferSize, int messageSize, FrameEncoder.PayloadAllocator payloadAllocator) {
        super(channel);
        WriteBufferWaterMark waterMark = channel.config().getWriteBufferWaterMark();
        this.lowWaterMark = waterMark.low();
        this.highWaterMark = waterMark.high();
        this.messageSize = messageSize;
        this.bufferSize = Math.min(messageSize, bufferSize);
        this.payloadAllocator = payloadAllocator;
        this.allocateBuffer();
    }

    private void allocateBuffer() {
        this.payload = this.payloadAllocator.allocate(false, this.bufferSize);
        this.buffer = this.payload.buffer;
    }

    @Override
    protected void doFlush(int count) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        FrameEncoder.Payload flush = this.payload;
        int byteCount = flush.length();
        if (byteCount == 0) {
            return;
        }
        if ((long)byteCount + this.flushed() > (long)(this.closing ? this.messageSize : this.messageSize - 1)) {
            throw new InvalidSerializedSizeException(this.messageSize, (long)byteCount + this.flushed());
        }
        flush.finish();
        ChannelPromise promise = this.beginFlush(byteCount, this.lowWaterMark, this.highWaterMark);
        this.channel.writeAndFlush(flush, promise);
        this.allocateBuffer();
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        if (this.flushed() == 0L && this.payload != null) {
            this.payload.setSelfContained(true);
        }
        super.close();
    }

    @Override
    public long position() {
        return this.flushed() + (long)this.payload.length();
    }

    @Override
    public void discard() {
        if (this.payload != null) {
            this.payload.release();
            this.payload = null;
            this.buffer = null;
        }
    }
}

