/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.metrics.SnapshottingReservoir;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecayingEstimatedHistogramReservoir
implements SnapshottingReservoir {
    private static final Logger logger = LoggerFactory.getLogger(DecayingEstimatedHistogramReservoir.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 5L, TimeUnit.MINUTES);
    public static final int DEFAULT_BUCKET_COUNT = 164;
    public static final int LOW_BUCKET_COUNT = 127;
    public static final int DEFAULT_STRIPE_COUNT = CassandraRelevantProperties.DECAYING_ESTIMATED_HISTOGRAM_RESERVOIR_STRIPE_COUNT.getInt();
    public static final int MAX_BUCKET_COUNT = 237;
    public static final boolean DEFAULT_ZERO_CONSIDERATION = false;
    private static final int[] DISTRIBUTION_PRIMES = new int[]{17, 19, 23, 29};
    public static final long[] DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, false);
    public static final long[] DEFAULT_WITH_ZERO_BUCKET_OFFSETS = EstimatedHistogram.newOffsets(164, true);
    private static final int TABLE_BITS = 4;
    private static final int TABLE_MASK = 15;
    private static final float[] LOG2_TABLE = DecayingEstimatedHistogramReservoir.computeTable(4);
    private static final float log2_12_recp = (float)(1.0 / DecayingEstimatedHistogramReservoir.slowLog2(1.2));
    private final int nStripes;
    private final long[] bucketOffsets;
    private final int distributionPrime;
    private static final AtomicReferenceFieldUpdater<DecayingEstimatedHistogramReservoir, DecayingBuckets> decayingBucketsUpdater = AtomicReferenceFieldUpdater.newUpdater(DecayingEstimatedHistogramReservoir.class, DecayingBuckets.class, "decayingBuckets");
    private volatile DecayingBuckets decayingBuckets;
    private final AtomicLongArray buckets;
    public static final long HALF_TIME_IN_S = 60L;
    public static final double MEAN_LIFETIME_IN_S = 60.0 / Math.log(2.0);
    public static final long LANDMARK_RESET_INTERVAL_IN_NS = TimeUnit.MINUTES.toNanos(30L);
    private final MonotonicClock clock;
    private final long landmarkResetIntervalInNs;

    private static float[] computeTable(int bits) {
        float[] table = new float[1 << bits];
        for (int i = 1; i < 1 << bits; ++i) {
            table[i] = (float)DecayingEstimatedHistogramReservoir.slowLog2(DecayingEstimatedHistogramReservoir.ratio(i, bits));
        }
        return table;
    }

    public static float fastLog12(long v) {
        return DecayingEstimatedHistogramReservoir.fastLog2(v) * log2_12_recp;
    }

    private static float fastLog2(long v) {
        v = Math.max(v, 1L);
        int highestBitPosition = 63 - Long.numberOfLeadingZeros(v);
        v = Long.rotateRight(v, highestBitPosition - 4);
        int index = (int)(v & 0xFL);
        float result = LOG2_TABLE[index];
        return result += (float)highestBitPosition;
    }

    private static double slowLog2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    private static double ratio(int i, int bits) {
        return Float.intBitsToFloat(0x3F800000 | i << 23 - bits);
    }

    public DecayingEstimatedHistogramReservoir() {
        this(false, 164, DEFAULT_STRIPE_COUNT, MonotonicClock.Global.approxTime);
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes) {
        this(considerZeroes, 164, DEFAULT_STRIPE_COUNT, MonotonicClock.Global.approxTime);
    }

    public DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, int stripes) {
        this(considerZeroes, bucketCount, stripes, MonotonicClock.Global.approxTime);
    }

    @VisibleForTesting
    public DecayingEstimatedHistogramReservoir(MonotonicClock clock) {
        this(false, 164, DEFAULT_STRIPE_COUNT, clock);
    }

    @VisibleForTesting
    DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, int stripes, MonotonicClock clock) {
        this(considerZeroes, bucketCount, stripes, clock, LANDMARK_RESET_INTERVAL_IN_NS);
    }

    @VisibleForTesting
    public DecayingEstimatedHistogramReservoir(boolean considerZeroes, int bucketCount, int stripes, MonotonicClock clock, long landmarkResetIntervalInNs) {
        assert (bucketCount <= 237) : "bucket count cannot exceed: 237";
        this.bucketOffsets = bucketCount == 164 ? (considerZeroes ? DEFAULT_WITH_ZERO_BUCKET_OFFSETS : DEFAULT_WITHOUT_ZERO_BUCKET_OFFSETS) : EstimatedHistogram.newOffsets(bucketCount, considerZeroes);
        this.nStripes = stripes;
        this.clock = clock;
        this.buckets = new AtomicLongArray((this.bucketOffsets.length + 1) * this.nStripes);
        this.decayingBuckets = new DecayingBuckets(clock.now());
        this.landmarkResetIntervalInNs = landmarkResetIntervalInNs;
        int distributionPrime = 1;
        for (int prime : DISTRIBUTION_PRIMES) {
            if (this.buckets.length() % prime == 0) continue;
            distributionPrime = prime;
            break;
        }
        this.distributionPrime = distributionPrime;
    }

    @Override
    public void update(long value) {
        long now = this.clock.now();
        DecayingBuckets rescaledDecayingBuckets = this.rescaleIfNeeded(now);
        int index = DecayingEstimatedHistogramReservoir.findIndex(this.bucketOffsets, value);
        rescaledDecayingBuckets.update(index, now);
        this.updateBucket(this.buckets, index, 1L);
    }

    public void updateBucket(AtomicLongArray buckets, int index, long value) {
        int stripe = (int)(Thread.currentThread().getId() & (long)(this.nStripes - 1));
        buckets.addAndGet(this.stripedIndex(index, stripe), value);
    }

    public int stripedIndex(int offsetIndex, int stripe) {
        return (offsetIndex * this.nStripes + stripe) * this.distributionPrime % this.buckets.length();
    }

    @VisibleForTesting
    public static int findIndex(long[] bucketOffsets, long value) {
        int offset = ((value = Math.max(value, 0L)) > 2L ? 3 : 1) + (int)bucketOffsets[0];
        int firstCandidate = Math.max(0, Math.min(bucketOffsets.length - 1, (int)DecayingEstimatedHistogramReservoir.fastLog12(value) - offset));
        return value <= bucketOffsets[firstCandidate] ? firstCandidate : firstCandidate + 1;
    }

    @Override
    public int size() {
        return this.bucketOffsets.length + 1;
    }

    public int stripeCount() {
        return this.nStripes;
    }

    @Override
    public Snapshot getSnapshot() {
        return new EstimatedHistogramReservoirSnapshot(this);
    }

    @Override
    public Snapshot getPercentileSnapshot() {
        return new DecayingBucketsOnlySnapshot(this);
    }

    private DecayingBuckets getDecayingBuckets() {
        return this.rescaleIfNeeded(this.clock.now());
    }

    @VisibleForTesting
    boolean isOverflowed() {
        return this.bucketValue(this.bucketOffsets.length, this.getDecayingBuckets().decayBuckets) > 0L;
    }

    private long bucketValue(int index, AtomicLongArray buckets) {
        long val = 0L;
        for (int stripe = 0; stripe < this.nStripes; ++stripe) {
            val += buckets.get(this.stripedIndex(index, stripe));
        }
        return val;
    }

    @VisibleForTesting
    long stripedBucketValue(int i, boolean withDecay) {
        return withDecay ? this.getDecayingBuckets().decayBuckets.get(i) : this.buckets.get(i);
    }

    private DecayingBuckets rescaleIfNeeded(long now) {
        DecayingBuckets buckets = this.decayingBuckets;
        while (now - buckets.decayLandmark > this.landmarkResetIntervalInNs) {
            double rescaleFactor = buckets.forwardDecayWeight(now);
            DecayingBuckets newBuckets = new DecayingBuckets(now);
            for (int i = 0; i < buckets.decayBuckets.length(); ++i) {
                newBuckets.decayBuckets.set(i, Math.round((double)buckets.decayBuckets.get(i) / rescaleFactor));
            }
            boolean success = decayingBucketsUpdater.compareAndSet(this, buckets, newBuckets);
            if (success) {
                return newBuckets;
            }
            buckets = this.decayingBuckets;
        }
        return buckets;
    }

    @VisibleForTesting
    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, 0L);
        }
        decayingBucketsUpdater.set(this, new DecayingBuckets(this.clock.now()));
    }

    private void rebase(EstimatedHistogramReservoirSnapshot snapshot) {
        if (this.size() != snapshot.decayingBuckets.length) {
            throw new IllegalStateException("Unable to merge two DecayingEstimatedHistogramReservoirs with different bucket sizes");
        }
        for (int i = 0; i < this.bucketOffsets.length; ++i) {
            if (this.bucketOffsets[i] == snapshot.bucketOffsets[i]) continue;
            throw new IllegalStateException("Merge is only supported with equal bucketOffsets");
        }
        DecayingBuckets newDecayingBuckets = new DecayingBuckets(snapshot.snapshotLandmark);
        for (int i = 0; i < this.size(); ++i) {
            newDecayingBuckets.decayBuckets.set(this.stripedIndex(i, 0), snapshot.decayingBuckets[i]);
            this.buckets.set(this.stripedIndex(i, 0), snapshot.values[i]);
            for (int stripe = 1; stripe < this.nStripes; ++stripe) {
                newDecayingBuckets.decayBuckets.set(this.stripedIndex(i, stripe), 0L);
                this.buckets.set(this.stripedIndex(i, stripe), 0L);
            }
        }
        decayingBucketsUpdater.set(this, newDecayingBuckets);
    }

    static class Range {
        public final long min;
        public final long max;

        public Range(long min2, long max) {
            this.min = min2;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range that = (Range)o;
            return this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        public String toString() {
            return "[" + this.min + "," + this.max + "]";
        }
    }

    private static class DecayingBucketsOnlySnapshot
    extends AbstractSnapshot {
        private final long count;

        public DecayingBucketsOnlySnapshot(DecayingEstimatedHistogramReservoir reservoir) {
            super(reservoir);
            int length = reservoir.size();
            DecayingBuckets decayingBucketsRef = reservoir.getDecayingBuckets();
            double rescaleFactor = decayingBucketsRef.forwardDecayWeight(reservoir.clock.now());
            for (int i = 0; i < length; ++i) {
                this.decayingBuckets[i] = Math.round((double)reservoir.bucketValue(i, decayingBucketsRef.decayBuckets) / rescaleFactor);
            }
            this.count = this.count();
        }

        @Override
        public long[] getValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return Ints.saturatedCast(this.count);
        }
    }

    static class EstimatedHistogramReservoirSnapshot
    extends AbstractSnapshot {
        private final long[] values;
        private long count;
        private long snapshotLandmark;
        private final DecayingEstimatedHistogramReservoir reservoir;

        public EstimatedHistogramReservoirSnapshot(DecayingEstimatedHistogramReservoir reservoir) {
            super(reservoir);
            int length = reservoir.size();
            this.values = new long[length];
            DecayingBuckets decayingBucketsRef = reservoir.getDecayingBuckets();
            this.snapshotLandmark = decayingBucketsRef.decayLandmark;
            double rescaleFactor = decayingBucketsRef.forwardDecayWeight(reservoir.clock.now());
            for (int i = 0; i < length; ++i) {
                this.decayingBuckets[i] = Math.round((double)reservoir.bucketValue(i, decayingBucketsRef.decayBuckets) / rescaleFactor);
                this.values[i] = reservoir.bucketValue(i, reservoir.buckets);
            }
            this.count = this.count();
            this.reservoir = reservoir;
        }

        @Override
        public long[] getValues() {
            return this.values;
        }

        @Override
        public int size() {
            return Ints.saturatedCast(this.count);
        }

        @VisibleForTesting
        public long getSnapshotLandmark() {
            return this.snapshotLandmark;
        }

        @VisibleForTesting
        public Range getBucketingRangeForValue(long value) {
            int index = DecayingEstimatedHistogramReservoir.findIndex(this.bucketOffsets, value);
            long max = this.bucketOffsets[index];
            long min2 = index == 0 ? 0L : 1L + this.bucketOffsets[index - 1];
            return new Range(min2, max);
        }

        public void add(Snapshot other) {
            int i;
            if (!(other instanceof EstimatedHistogramReservoirSnapshot)) {
                throw new IllegalStateException("Unable to add other types of Snapshot than another DecayingEstimatedHistogramReservoir");
            }
            EstimatedHistogramReservoirSnapshot snapshot = (EstimatedHistogramReservoirSnapshot)other;
            if (this.decayingBuckets.length != snapshot.decayingBuckets.length) {
                throw new IllegalStateException("Unable to merge two DecayingEstimatedHistogramReservoirs with different bucket sizes");
            }
            for (i = 0; i < this.bucketOffsets.length; ++i) {
                if (this.bucketOffsets[i] == snapshot.bucketOffsets[i]) continue;
                throw new IllegalStateException("Merge is only supported with equal bucketOffsets");
            }
            if (snapshot.snapshotLandmark < this.snapshotLandmark) {
                this.rescaleArray(snapshot.decayingBuckets, this.snapshotLandmark - snapshot.snapshotLandmark);
            } else if (snapshot.snapshotLandmark > this.snapshotLandmark) {
                this.rescaleArray(this.decayingBuckets, snapshot.snapshotLandmark - this.snapshotLandmark);
                this.snapshotLandmark = snapshot.snapshotLandmark;
            }
            for (i = 0; i < snapshot.decayingBuckets.length; ++i) {
                int n = i;
                this.decayingBuckets[n] = this.decayingBuckets[n] + snapshot.decayingBuckets[i];
                int n2 = i;
                this.values[n2] = this.values[n2] + snapshot.values[i];
            }
            this.count += snapshot.count;
        }

        private void rescaleArray(long[] decayingBuckets, long landMarkDifference) {
            double rescaleFactor = Math.exp((double)landMarkDifference / 1000.0 / MEAN_LIFETIME_IN_S);
            for (int i = 0; i < decayingBuckets.length; ++i) {
                decayingBuckets[i] = Math.round((double)decayingBuckets[i] / rescaleFactor);
            }
        }

        public void rebaseReservoir() {
            this.reservoir.rebase(this);
        }
    }

    private static abstract class AbstractSnapshot
    extends Snapshot {
        protected final long[] decayingBuckets;
        protected final long[] bucketOffsets;

        AbstractSnapshot(DecayingEstimatedHistogramReservoir reservoir) {
            int length = reservoir.size();
            this.decayingBuckets = new long[length];
            this.bucketOffsets = reservoir.bucketOffsets;
        }

        @Override
        public double getValue(double quantile) {
            long qcount;
            assert (quantile >= 0.0 && quantile <= 1.0);
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                try {
                    throw new IllegalStateException("EstimatedHistogram overflow: " + Arrays.toString(this.decayingBuckets));
                }
                catch (IllegalStateException e) {
                    noSpamLogger.warn("", e);
                }
            }
            if ((qcount = (long)Math.ceil((double)this.count() * quantile)) == 0L) {
                return 0.0;
            }
            long elements = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                if ((elements += this.decayingBuckets[i]) < qcount) continue;
                return this.bucketOffsets[i];
            }
            return 0.0;
        }

        protected long count() {
            long sum = 0L;
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                sum += this.decayingBuckets[i];
            }
            return sum;
        }

        @Override
        public long getMax() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                return Long.MAX_VALUE;
            }
            for (int i = lastBucket - 1; i >= 0; --i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return this.bucketOffsets[i];
            }
            return 0L;
        }

        @Override
        public double getMean() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long elements = 0L;
            long sum = 0L;
            for (int i = 0; i < lastBucket; ++i) {
                long bCount = this.decayingBuckets[i];
                elements += bCount;
                sum += bCount * this.bucketOffsets[i];
            }
            return (double)sum / (double)elements;
        }

        @Override
        public long getMin() {
            for (int i = 0; i < this.decayingBuckets.length; ++i) {
                if (this.decayingBuckets[i] <= 0L) continue;
                return i == 0 ? 0L : 1L + this.bucketOffsets[i - 1];
            }
            return 0L;
        }

        @Override
        public double getStdDev() {
            int lastBucket = this.decayingBuckets.length - 1;
            if (this.decayingBuckets[lastBucket] > 0L) {
                throw new IllegalStateException("Unable to compute when histogram overflowed");
            }
            long count = this.count();
            if (count <= 1L) {
                return 0.0;
            }
            double mean = this.getMean();
            double sum = 0.0;
            for (int i = 0; i < lastBucket; ++i) {
                long value = this.bucketOffsets[i];
                double diff = (double)value - mean;
                sum += diff * diff * (double)this.decayingBuckets[i];
            }
            return Math.sqrt(sum / (double)(count - 1L));
        }

        @Override
        public void dump(OutputStream output) {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                int length = this.decayingBuckets.length;
                for (int i = 0; i < length; ++i) {
                    out.printf("%d%n", this.decayingBuckets[i]);
                }
            }
        }
    }

    private class DecayingBuckets {
        private final long decayLandmark;
        private final AtomicLongArray decayBuckets;

        public DecayingBuckets(long decayLandmark) {
            this.decayLandmark = decayLandmark;
            this.decayBuckets = new AtomicLongArray((DecayingEstimatedHistogramReservoir.this.bucketOffsets.length + 1) * DecayingEstimatedHistogramReservoir.this.nStripes);
        }

        public void update(int index, long now) {
            DecayingEstimatedHistogramReservoir.this.updateBucket(this.decayBuckets, index, this.forwardDecayWeight(now));
        }

        private long forwardDecayWeight(long now) {
            return Math.round(Math.exp((double)TimeUnit.NANOSECONDS.toSeconds(now - this.decayLandmark) / MEAN_LIFETIME_IN_S));
        }
    }
}

