/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Histogram;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.LongAdder;
import org.apache.cassandra.metrics.DecayingEstimatedHistogramReservoir;

public class ClearableHistogram
extends Histogram {
    private final DecayingEstimatedHistogramReservoir reservoirRef;

    public ClearableHistogram(DecayingEstimatedHistogramReservoir reservoir) {
        super(reservoir);
        this.reservoirRef = reservoir;
    }

    @VisibleForTesting
    public void clear() {
        this.clearCount();
        this.reservoirRef.clear();
    }

    private void clearCount() {
        try {
            Field countField = Histogram.class.getDeclaredField("count");
            countField.setAccessible(true);
            Object counter = countField.get(this);
            if (counter instanceof LongAdder) {
                ((LongAdder)counter).reset();
            } else {
                Method sumThenReset = counter.getClass().getDeclaredMethod("sumThenReset", new Class[0]);
                sumThenReset.setAccessible(true);
                sumThenReset.invoke(counter, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot reset the com.codahale.metrics.Histogram count. This might be due to a change of version of the metric library", e);
        }
    }
}

