/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceSnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.locator.SnitchUtils;

public class GoogleCloudSnitch
extends AbstractCloudMetadataServiceSnitch {
    static final String DEFAULT_METADATA_SERVICE_URL = "http://metadata.google.internal";
    static final String ZONE_NAME_QUERY_URL = "/computeMetadata/v1/instance/zone";

    public GoogleCloudSnitch() throws IOException {
        this(new SnitchProperties());
    }

    public GoogleCloudSnitch(SnitchProperties properties) throws IOException {
        this(new AbstractCloudMetadataServiceConnector.DefaultCloudMetadataServiceConnector(properties.putIfAbsent("metadata_url", DEFAULT_METADATA_SERVICE_URL)));
    }

    public GoogleCloudSnitch(AbstractCloudMetadataServiceConnector connector) throws IOException {
        super(connector, SnitchUtils.parseDcAndRack(connector.apiCall(ZONE_NAME_QUERY_URL, ImmutableMap.of("Metadata-Flavor", "Google")), connector.getProperties().getDcSuffix()));
    }
}

