/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.bbtree.NumericIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentTrieBuffer;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentWriter;
import org.apache.cassandra.index.sai.disk.v1.trie.LiteralIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.vector.OnHeapGraph;
import org.apache.cassandra.index.sai.utils.NamedMemoryLimiter;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class SegmentBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SegmentBuilder.class);
    public static final long LAST_VALID_SEGMENT_ROW_ID = 0x3FFFFFFEL;
    private static long testLastValidSegmentRowId = -1L;
    private static final AtomicInteger ACTIVE_BUILDER_COUNT = new AtomicInteger(0);
    private static volatile long minimumFlushBytes;
    private final NamedMemoryLimiter limiter;
    private final long lastValidSegmentRowID;
    private boolean flushed = false;
    private boolean active = true;
    private long minSSTableRowId = -1L;
    private long maxSSTableRowId = -1L;
    private long segmentRowIdOffset = 0L;
    private PrimaryKey minKey;
    private PrimaryKey maxKey;
    private ByteBuffer minTerm;
    private ByteBuffer maxTerm;
    final StorageAttachedIndex index;
    long totalBytesAllocated;
    int rowCount = 0;
    int maxSegmentRowId = -1;

    public static int getActiveBuilderCount() {
        return ACTIVE_BUILDER_COUNT.get();
    }

    private SegmentBuilder(StorageAttachedIndex index, NamedMemoryLimiter limiter) {
        this.index = index;
        this.limiter = limiter;
        this.lastValidSegmentRowID = testLastValidSegmentRowId >= 0L ? testLastValidSegmentRowId : 0x3FFFFFFEL;
        minimumFlushBytes = limiter.limitBytes() / (long)ACTIVE_BUILDER_COUNT.incrementAndGet();
    }

    public SegmentMetadata flush(IndexDescriptor indexDescriptor) throws IOException {
        assert (!this.flushed) : "Cannot flush an already flushed segment";
        this.flushed = true;
        if (this.getRowCount() == 0) {
            logger.warn(this.index.identifier().logMessage("No rows to index during flush of SSTable {}."), (Object)indexDescriptor.sstableDescriptor);
            return null;
        }
        SegmentMetadata.ComponentMetadataMap indexMetas = this.flushInternal(indexDescriptor);
        return new SegmentMetadata(this.segmentRowIdOffset, this.rowCount, this.minSSTableRowId, this.maxSSTableRowId, this.minKey, this.maxKey, this.minTerm, this.maxTerm, indexMetas);
    }

    public long add(ByteBuffer term, PrimaryKey key, long sstableRowId) {
        assert (!this.flushed) : "Cannot add to a flushed segment.";
        assert (sstableRowId >= this.maxSSTableRowId);
        this.minSSTableRowId = this.minSSTableRowId < 0L ? sstableRowId : this.minSSTableRowId;
        this.maxSSTableRowId = sstableRowId;
        assert (this.maxKey == null || this.maxKey.compareTo(key) <= 0);
        if (this.minKey == null) {
            this.minKey = key;
        }
        this.maxKey = key;
        this.minTerm = this.index.termType().min(term, this.minTerm);
        this.maxTerm = this.index.termType().max(term, this.maxTerm);
        if (this.rowCount == 0) {
            this.segmentRowIdOffset = sstableRowId;
        }
        ++this.rowCount;
        int segmentRowId = SegmentBuilder.castToSegmentRowId(sstableRowId, this.segmentRowIdOffset);
        this.maxSegmentRowId = Math.max(this.maxSegmentRowId, segmentRowId);
        long bytesAllocated = this.addInternal(term, segmentRowId);
        this.totalBytesAllocated += bytesAllocated;
        return bytesAllocated;
    }

    public static int castToSegmentRowId(long sstableRowId, long segmentRowIdOffset) {
        return Math.toIntExact(sstableRowId - segmentRowIdOffset);
    }

    public long totalBytesAllocated() {
        return this.totalBytesAllocated;
    }

    public boolean hasReachedMinimumFlushSize() {
        return this.totalBytesAllocated >= minimumFlushBytes;
    }

    public long getMinimumFlushBytes() {
        return minimumFlushBytes;
    }

    public long release() {
        if (this.active) {
            minimumFlushBytes = this.limiter.limitBytes() / (long)ACTIVE_BUILDER_COUNT.getAndDecrement();
            long used = this.limiter.decrement(this.totalBytesAllocated);
            this.active = false;
            return used;
        }
        logger.warn(this.index.identifier().logMessage("Attempted to release storage-attached index segment builder memory after builder marked inactive."));
        return this.limiter.currentBytesUsed();
    }

    public abstract boolean isEmpty();

    protected abstract long addInternal(ByteBuffer var1, int var2);

    protected abstract SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor var1) throws IOException;

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean exceedsSegmentLimit(long ssTableRowId) {
        if (this.getRowCount() == 0) {
            return false;
        }
        return ssTableRowId - this.segmentRowIdOffset > this.lastValidSegmentRowID;
    }

    @VisibleForTesting
    public static void updateLastValidSegmentRowId(long lastValidSegmentRowID) {
        testLastValidSegmentRowId = lastValidSegmentRowID;
    }

    public static class VectorSegmentBuilder
    extends SegmentBuilder {
        private final OnHeapGraph<Integer> graphIndex;

        public VectorSegmentBuilder(StorageAttachedIndex index, NamedMemoryLimiter limiter) {
            super(index, limiter);
            this.graphIndex = new OnHeapGraph(index.termType().indexType(), index.indexWriterConfig(), false);
        }

        @Override
        public boolean isEmpty() {
            return this.graphIndex.isEmpty();
        }

        @Override
        protected long addInternal(ByteBuffer term, int segmentRowId) {
            return this.graphIndex.add(term, segmentRowId, OnHeapGraph.InvalidVectorBehavior.IGNORE);
        }

        @Override
        protected SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor indexDescriptor) throws IOException {
            return this.graphIndex.writeData(indexDescriptor, this.index.identifier(), p -> p);
        }
    }

    public static class TrieSegmentBuilder
    extends SegmentBuilder {
        protected final SegmentTrieBuffer segmentTrieBuffer = new SegmentTrieBuffer();

        public TrieSegmentBuilder(StorageAttachedIndex index, NamedMemoryLimiter limiter) {
            super(index, limiter);
            this.totalBytesAllocated = this.segmentTrieBuffer.memoryUsed();
        }

        @Override
        protected long addInternal(ByteBuffer term, int segmentRowId) {
            return this.segmentTrieBuffer.add((ByteComparable.Version v) -> this.index.termType().asComparableBytes(term, v), term.limit(), segmentRowId);
        }

        @Override
        protected SegmentMetadata.ComponentMetadataMap flushInternal(IndexDescriptor indexDescriptor) throws IOException {
            SegmentWriter writer = this.index.termType().isLiteral() ? new LiteralIndexWriter(indexDescriptor, this.index.identifier()) : new NumericIndexWriter(indexDescriptor, this.index.identifier(), this.index.termType().fixedSizeOf());
            return writer.writeCompleteSegment(this.segmentTrieBuffer.iterator());
        }

        @Override
        public boolean isEmpty() {
            return this.segmentTrieBuffer.numRows() == 0;
        }
    }
}

