/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreePostingsWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWalker;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentWriter;
import org.apache.cassandra.index.sai.utils.IndexEntry;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.PackedLongValues;

public class NumericIndexWriter
implements SegmentWriter {
    public static final int MAX_POINTS_IN_LEAF_NODE = 1024;
    private static final int DEFAULT_POSTINGS_SIZE = 128;
    private final BlockBalancedTreeWriter writer;
    private final IndexDescriptor indexDescriptor;
    private final IndexIdentifier indexIdentifier;
    private final int bytesPerValue;

    public NumericIndexWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier, int bytesPerValue) {
        this(indexDescriptor, indexIdentifier, 1024, bytesPerValue);
    }

    @VisibleForTesting
    public NumericIndexWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier, int maxPointsInLeafNode, int bytesPerValue) {
        this.indexDescriptor = indexDescriptor;
        this.indexIdentifier = indexIdentifier;
        this.bytesPerValue = bytesPerValue;
        this.writer = new BlockBalancedTreeWriter(bytesPerValue, maxPointsInLeafNode);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("indexName", this.indexIdentifier).add("bytesPerValue", this.bytesPerValue).toString();
    }

    @Override
    public SegmentMetadata.ComponentMetadataMap writeCompleteSegment(Iterator<IndexEntry> iterator) throws IOException {
        long treePosition;
        SegmentMetadata.ComponentMetadataMap components = new SegmentMetadata.ComponentMetadataMap();
        LeafCallback leafCallback = new LeafCallback();
        try (IndexOutputWriter treeOutput = this.indexDescriptor.openPerIndexOutput(IndexComponent.BALANCED_TREE, this.indexIdentifier, true);){
            long treeOffset = ((IndexOutput)treeOutput).getFilePointer();
            treePosition = this.writer.write(treeOutput, iterator, leafCallback);
            if (treePosition < 0L) {
                SegmentMetadata.ComponentMetadataMap componentMetadataMap = components;
                return componentMetadataMap;
            }
            long treeLength = ((IndexOutput)treeOutput).getFilePointer() - treeOffset;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("max_points_in_leaf_node", Integer.toString(this.writer.getMaxPointsInLeafNode()));
            attributes.put("num_leaves", Integer.toString(leafCallback.numLeaves()));
            attributes.put("num_values", Long.toString(this.writer.getValueCount()));
            attributes.put("bytes_per_value", Long.toString(this.writer.getBytesPerValue()));
            components.put(IndexComponent.BALANCED_TREE, treePosition, treeOffset, treeLength, attributes);
        }
        try (BlockBalancedTreeWalker reader = new BlockBalancedTreeWalker(this.indexDescriptor.createPerIndexFileHandle(IndexComponent.BALANCED_TREE, this.indexIdentifier, null), treePosition);
             IndexOutputWriter postingsOutput = this.indexDescriptor.openPerIndexOutput(IndexComponent.POSTING_LISTS, this.indexIdentifier, true);){
            long postingsOffset = postingsOutput.getFilePointer();
            BlockBalancedTreePostingsWriter postingsWriter = new BlockBalancedTreePostingsWriter();
            reader.traverse(postingsWriter);
            long postingsPosition = postingsWriter.finish(postingsOutput, leafCallback.leafPostings, this.indexIdentifier);
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("num_leaf_postings", Integer.toString(postingsWriter.numLeafPostings));
            attributes.put("num_non_leaf_postings", Integer.toString(postingsWriter.numNonLeafPostings));
            long postingsLength = postingsOutput.getFilePointer() - postingsOffset;
            components.put(IndexComponent.POSTING_LISTS, postingsPosition, postingsOffset, postingsLength, attributes);
        }
        return components;
    }

    @Override
    public long getNumberOfRows() {
        return this.writer.getValueCount();
    }

    private static class LeafCallback
    implements BlockBalancedTreeWriter.Callback {
        final List<PackedLongValues> leafPostings = new ArrayList<PackedLongValues>(128);

        private LeafCallback() {
        }

        public int numLeaves() {
            return this.leafPostings.size();
        }

        @Override
        public void writeLeafPostings(BlockBalancedTreeWriter.RowIDAndIndex[] leafPostings, int offset, int count) {
            PackedLongValues.Builder builder = PackedLongValues.monotonicBuilder(0.0f);
            for (int i = offset; i < count; ++i) {
                builder.add(leafPostings[i].rowID);
            }
            this.leafPostings.add(builder.build());
        }
    }
}

