/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

@NotThreadSafe
public class MetadataSource {
    private final Map<String, BytesRef> components;

    private MetadataSource(Map<String, BytesRef> components) {
        this.components = components;
    }

    public static MetadataSource loadGroupMetadata(IndexDescriptor indexDescriptor) throws IOException {
        return MetadataSource.load(indexDescriptor.openPerSSTableInput(IndexComponent.GROUP_META));
    }

    public static MetadataSource loadColumnMetadata(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
        return MetadataSource.load(indexDescriptor.openPerIndexInput(IndexComponent.META, indexIdentifier));
    }

    private static MetadataSource load(IndexInput indexInput) throws IOException {
        HashMap<String, BytesRef> components = new HashMap<String, BytesRef>();
        try (ChecksumIndexInput input = IndexFileUtils.getBufferedChecksumIndexInput(indexInput);){
            SAICodecUtils.checkHeader(input);
            int num = input.readInt();
            for (int x = 0; x < num; ++x) {
                if (input.length() == input.getFilePointer()) {
                    throw new IllegalStateException("Unexpected EOF in " + input);
                }
                String name = input.readString();
                int length = input.readInt();
                byte[] bytes = new byte[length];
                input.readBytes(bytes, 0, length);
                components.put(name, new BytesRef(bytes));
            }
            SAICodecUtils.checkFooter(input);
        }
        return new MetadataSource(components);
    }

    public DataInput get(String name) {
        BytesRef bytes = this.components.get(name);
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Could not find component '%s'. Available properties are %s.", name, this.components.keySet()));
        }
        return new ByteArrayDataInput(bytes.bytes);
    }
}

