/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.gms.ArrayBackedBoundedStats;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static final Logger logger = LoggerFactory.getLogger(ArrivalWindow.class);
    private long tLast = 0L;
    private final ArrayBackedBoundedStats arrivalIntervals;
    private double lastReportedPhi = Double.MIN_VALUE;
    private final long MAX_INTERVAL_IN_NANO = ArrivalWindow.getMaxInterval();

    ArrivalWindow(int size) {
        this.arrivalIntervals = new ArrayBackedBoundedStats(size);
    }

    private static long getMaxInterval() {
        long newValue = CassandraRelevantProperties.FD_MAX_INTERVAL_MS.getLong(FailureDetector.INITIAL_VALUE_NANOS);
        if (newValue != FailureDetector.INITIAL_VALUE_NANOS) {
            logger.info("Overriding {} from {}ms to {}ms", new Object[]{CassandraRelevantProperties.FD_MAX_INTERVAL_MS.getKey(), FailureDetector.INITIAL_VALUE_NANOS, newValue});
        }
        return TimeUnit.NANOSECONDS.convert(newValue, TimeUnit.MILLISECONDS);
    }

    synchronized void add(long value, InetAddressAndPort ep) {
        assert (this.tLast >= 0L);
        if (this.tLast > 0L) {
            long interArrivalTime = value - this.tLast;
            if (interArrivalTime <= this.MAX_INTERVAL_IN_NANO) {
                this.arrivalIntervals.add(interArrivalTime);
                logger.trace("Reporting interval time of {}ns for {}", (Object)interArrivalTime, (Object)ep);
            } else {
                logger.trace("Ignoring interval time of {}ns for {}", (Object)interArrivalTime, (Object)ep);
            }
        } else {
            this.arrivalIntervals.add(FailureDetector.INITIAL_VALUE_NANOS);
        }
        this.tLast = value;
    }

    double mean() {
        return this.arrivalIntervals.mean();
    }

    double phi(long tnow) {
        assert (this.arrivalIntervals.mean() > 0.0 && this.tLast > 0L);
        long t2 = tnow - this.tLast;
        this.lastReportedPhi = (double)t2 / this.mean();
        return this.lastReportedPhi;
    }

    double getLastReportedPhi() {
        return this.lastReportedPhi;
    }

    public String toString() {
        return Arrays.toString(this.arrivalIntervals.getArrivalIntervals());
    }
}

