/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.apache.cassandra.db.tries.CollectionMergeTrie;
import org.apache.cassandra.db.tries.MergeTrie;
import org.apache.cassandra.db.tries.SingletonTrie;
import org.apache.cassandra.db.tries.SlicedTrie;
import org.apache.cassandra.db.tries.TrieDumper;
import org.apache.cassandra.db.tries.TrieEntriesIterator;
import org.apache.cassandra.db.tries.TrieEntriesWalker;
import org.apache.cassandra.db.tries.TrieValuesIterator;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public abstract class Trie<T> {
    protected static final ByteComparable.Version BYTE_COMPARABLE_VERSION = ByteComparable.Version.OSS50;
    private static final CollectionMergeResolver<Object> THROWING_RESOLVER = new CollectionMergeResolver<Object>(){

        @Override
        public Object resolve(Collection<Object> contents) {
            throw this.error();
        }

        private AssertionError error() {
            throw new AssertionError((Object)"Entries must be distinct.");
        }
    };
    private static final Trie<Object> EMPTY = new Trie<Object>(){

        @Override
        protected Cursor<Object> cursor() {
            return new Cursor<Object>(){
                int depth = 0;

                @Override
                public int advance() {
                    this.depth = -1;
                    return -1;
                }

                @Override
                public int skipChildren() {
                    this.depth = -1;
                    return -1;
                }

                @Override
                public int depth() {
                    return this.depth;
                }

                @Override
                public Object content() {
                    return null;
                }

                @Override
                public int incomingTransition() {
                    return -1;
                }
            };
        }
    };

    protected abstract Cursor<T> cursor();

    public void forEachValue(ValueConsumer<T> consumer) {
        this.process(consumer);
    }

    public void forEachEntry(BiConsumer<ByteComparable, T> consumer) {
        this.process(new TrieEntriesWalker.WithConsumer<T>(consumer));
    }

    public <R> R process(Walker<T, R> walker) {
        return Trie.process(walker, this.cursor());
    }

    static <T, R> R process(Walker<T, R> walker, Cursor<T> cursor) {
        assert (cursor.depth() == 0) : "The provided cursor has already been advanced.";
        T content = cursor.content();
        if (content == null) {
            content = cursor.advanceToContent(walker);
        }
        while (content != null) {
            walker.content(content);
            content = cursor.advanceToContent(walker);
        }
        return walker.complete();
    }

    public String dump() {
        return this.dump(Object::toString);
    }

    public String dump(Function<T, String> contentToString) {
        return (String)this.process(new TrieDumper<T>(contentToString));
    }

    public static <T> Trie<T> singleton(ByteComparable b, T v) {
        return new SingletonTrie<T>(b, v);
    }

    public Trie<T> subtrie(ByteComparable left, boolean includeLeft, ByteComparable right, boolean includeRight) {
        if (left == null && right == null) {
            return this;
        }
        return new SlicedTrie(this, left, includeLeft, right, includeRight);
    }

    public Trie<T> subtrie(ByteComparable left, ByteComparable right) {
        return this.subtrie(left, true, right, false);
    }

    public Iterable<Map.Entry<ByteComparable, T>> entrySet() {
        return this::entryIterator;
    }

    public Iterator<Map.Entry<ByteComparable, T>> entryIterator() {
        return new TrieEntriesIterator.AsEntries(this);
    }

    public Iterable<T> values() {
        return this::valueIterator;
    }

    public Iterator<T> valueIterator() {
        return new TrieValuesIterator(this);
    }

    public Iterable<T> valuesUnordered() {
        return this.values();
    }

    public Trie<T> mergeWith(Trie<T> other, MergeResolver<T> resolver) {
        return new MergeTrie<T>(resolver, this, other);
    }

    public static <T> CollectionMergeResolver<T> throwingResolver() {
        return THROWING_RESOLVER;
    }

    public static <T> Trie<T> merge(Collection<? extends Trie<T>> sources, CollectionMergeResolver<T> resolver) {
        switch (sources.size()) {
            case 0: {
                return Trie.empty();
            }
            case 1: {
                return sources.iterator().next();
            }
            case 2: {
                Iterator<Trie<T>> it = sources.iterator();
                Trie<T> t1 = it.next();
                Trie<T> t2 = it.next();
                return t1.mergeWith(t2, resolver);
            }
        }
        return new CollectionMergeTrie<T>(sources, resolver);
    }

    public static <T> Trie<T> mergeDistinct(Collection<? extends Trie<T>> sources) {
        switch (sources.size()) {
            case 0: {
                return Trie.empty();
            }
            case 1: {
                return sources.iterator().next();
            }
            case 2: {
                Iterator<Trie<T>> it = sources.iterator();
                Trie<T> t1 = it.next();
                Trie<T> t2 = it.next();
                return new MergeTrie.Distinct<T>(t1, t2);
            }
        }
        return new CollectionMergeTrie.Distinct(sources);
    }

    public static <T> Trie<T> empty() {
        return EMPTY;
    }

    public static interface CollectionMergeResolver<T>
    extends MergeResolver<T> {
        public T resolve(Collection<T> var1);

        @Override
        default public T resolve(T c1, T c2) {
            return this.resolve(ImmutableList.of(c1, c2));
        }
    }

    public static interface MergeResolver<T> {
        public T resolve(T var1, T var2);
    }

    public static interface ValueConsumer<T>
    extends Consumer<T>,
    Walker<T, Void> {
        @Override
        default public void content(T content) {
            this.accept(content);
        }

        @Override
        default public Void complete() {
            return null;
        }

        @Override
        default public void resetPathLength(int newDepth) {
        }

        @Override
        default public void addPathByte(int nextByte) {
        }

        @Override
        default public void addPathBytes(DirectBuffer buffer, int pos, int count) {
        }
    }

    protected static interface Walker<T, R>
    extends ResettingTransitionsReceiver {
        public void content(T var1);

        public R complete();
    }

    protected static interface ResettingTransitionsReceiver
    extends TransitionsReceiver {
        public void resetPathLength(int var1);
    }

    protected static interface TransitionsReceiver {
        public void addPathByte(int var1);

        public void addPathBytes(DirectBuffer var1, int var2, int var3);
    }

    protected static interface Cursor<T> {
        public int depth();

        public int incomingTransition();

        public T content();

        public int advance();

        default public int advanceMultiple(TransitionsReceiver receiver) {
            return this.advance();
        }

        default public T advanceToContent(ResettingTransitionsReceiver receiver) {
            int prevDepth = this.depth();
            int currDepth;
            while ((currDepth = this.advanceMultiple(receiver)) > 0) {
                T content;
                if (receiver != null) {
                    if (currDepth <= prevDepth) {
                        receiver.resetPathLength(currDepth - 1);
                    }
                    receiver.addPathByte(this.incomingTransition());
                }
                if ((content = this.content()) != null) {
                    return content;
                }
                prevDepth = currDepth;
            }
            return null;
        }

        public int skipChildren();
    }
}

