/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import com.google.common.collect.Iterables;
import org.apache.cassandra.db.tries.Trie;

class MergeTrie<T>
extends Trie<T> {
    private final Trie.MergeResolver<T> resolver;
    protected final Trie<T> t1;
    protected final Trie<T> t2;

    MergeTrie(Trie.MergeResolver<T> resolver, Trie<T> t1, Trie<T> t2) {
        this.resolver = resolver;
        this.t1 = t1;
        this.t2 = t2;
    }

    @Override
    protected Trie.Cursor<T> cursor() {
        return new MergeCursor<T>(this.resolver, this.t1, this.t2);
    }

    static class Distinct<T>
    extends MergeTrie<T> {
        Distinct(Trie<T> input1, Trie<T> input2) {
            super(Distinct.throwingResolver(), input1, input2);
        }

        @Override
        public Iterable<T> valuesUnordered() {
            return Iterables.concat(this.t1.valuesUnordered(), this.t2.valuesUnordered());
        }
    }

    static class MergeCursor<T>
    implements Trie.Cursor<T> {
        private final Trie.MergeResolver<T> resolver;
        private final Trie.Cursor<T> c1;
        private final Trie.Cursor<T> c2;
        boolean atC1;
        boolean atC2;

        MergeCursor(Trie.MergeResolver<T> resolver, Trie<T> t1, Trie<T> t2) {
            this.resolver = resolver;
            this.c1 = t1.cursor();
            this.c2 = t2.cursor();
            assert (this.c1.depth() == 0);
            assert (this.c2.depth() == 0);
            this.atC2 = true;
            this.atC1 = true;
        }

        @Override
        public int advance() {
            return this.checkOrder(this.atC1 ? this.c1.advance() : this.c1.depth(), this.atC2 ? this.c2.advance() : this.c2.depth());
        }

        @Override
        public int skipChildren() {
            return this.checkOrder(this.atC1 ? this.c1.skipChildren() : this.c1.depth(), this.atC2 ? this.c2.skipChildren() : this.c2.depth());
        }

        @Override
        public int advanceMultiple(Trie.TransitionsReceiver receiver) {
            if (this.atC1 && this.atC2) {
                return this.checkOrder(this.c1.advance(), this.c2.advance());
            }
            if (this.atC1) {
                return this.checkOrder(this.c1.advanceMultiple(receiver), this.c2.depth());
            }
            return this.checkOrder(this.c1.depth(), this.c2.advanceMultiple(receiver));
        }

        private int checkOrder(int c1depth, int c2depth) {
            int c2trans;
            if (c1depth > c2depth) {
                this.atC1 = true;
                this.atC2 = false;
                return c1depth;
            }
            if (c1depth < c2depth) {
                this.atC1 = false;
                this.atC2 = true;
                return c2depth;
            }
            int c1trans = this.c1.incomingTransition();
            this.atC1 = c1trans <= (c2trans = this.c2.incomingTransition());
            this.atC2 = c1trans >= c2trans;
            return c1depth;
        }

        @Override
        public int depth() {
            return this.atC1 ? this.c1.depth() : this.c2.depth();
        }

        @Override
        public int incomingTransition() {
            return this.atC1 ? this.c1.incomingTransition() : this.c2.incomingTransition();
        }

        @Override
        public T content() {
            Object nc;
            Object mc = this.atC2 ? (Object)this.c2.content() : null;
            Object t2 = nc = this.atC1 ? (Object)this.c1.content() : null;
            if (mc == null) {
                return nc;
            }
            if (nc == null) {
                return mc;
            }
            return this.resolver.resolve(nc, mc);
        }
    }
}

