/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.MergeIterator;

public abstract class Rows {
    public static final Row EMPTY_STATIC_ROW = BTreeRow.emptyRow(Clustering.STATIC_CLUSTERING);

    private Rows() {
    }

    public static Row.SimpleBuilder simpleBuilder(TableMetadata metadata, Object ... clusteringValues) {
        return new SimpleBuilders.RowBuilder(metadata, clusteringValues);
    }

    public static int collectStats(Row row, PartitionStatisticsCollector collector) {
        assert (!row.isEmpty());
        collector.update(row.primaryKeyLivenessInfo());
        collector.update(row.deletion().time());
        long result = row.accumulate((x$0, x$1, x$2) -> StatsAccumulation.accumulateOnColumnData(x$0, x$1, x$2), collector, 0L);
        collector.updateColumnSetPerRow(StatsAccumulation.unpackColumnCount(result));
        return StatsAccumulation.unpackCellCount(result);
    }

    public static void diff(final RowDiffListener diffListener, Row merged, final Row ... inputs) {
        ClusteringPrefix clustering = merged.clustering();
        LivenessInfo mergedInfo = merged.primaryKeyLivenessInfo().isEmpty() ? null : merged.primaryKeyLivenessInfo();
        Row.Deletion mergedDeletion = merged.deletion().isLive() ? null : merged.deletion();
        for (int i = 0; i < inputs.length; ++i) {
            Row.Deletion inputDeletion;
            Row[] input = inputs[i];
            LivenessInfo inputInfo = input == null || input.primaryKeyLivenessInfo().isEmpty() ? null : input.primaryKeyLivenessInfo();
            Row.Deletion deletion = inputDeletion = input == null || input.deletion().isLive() ? null : input.deletion();
            if (mergedInfo != null || inputInfo != null) {
                diffListener.onPrimaryKeyLivenessInfo(i, (Clustering<?>)clustering, mergedInfo, inputInfo);
            }
            if (mergedDeletion == null && inputDeletion == null) continue;
            diffListener.onDeletion(i, (Clustering<?>)clustering, mergedDeletion, inputDeletion);
        }
        ArrayList inputIterators = new ArrayList(1 + inputs.length);
        inputIterators.add(merged.iterator());
        for (Row row : inputs) {
            inputIterators.add(row == null ? Collections.emptyIterator() : row.iterator());
        }
        MergeIterator<ColumnData, Object> iter2 = MergeIterator.get(inputIterators, ColumnData.comparator, new MergeIterator.Reducer<ColumnData, Object>((Clustering)clustering){
            ColumnData mergedData;
            ColumnData[] inputDatas;
            final /* synthetic */ Clustering val$clustering;
            {
                this.val$clustering = clustering;
                this.inputDatas = new ColumnData[inputs.length];
            }

            @Override
            public void reduce(int idx, ColumnData current) {
                if (idx == 0) {
                    this.mergedData = current;
                } else {
                    this.inputDatas[idx - 1] = current;
                }
            }

            @Override
            protected Object getReduced() {
                for (int i = 0; i != this.inputDatas.length; ++i) {
                    ColumnData input = this.inputDatas[i];
                    if (this.mergedData == null && input == null) continue;
                    ColumnMetadata column = (this.mergedData != null ? this.mergedData : input).column;
                    if (column.isSimple()) {
                        diffListener.onCell(i, this.val$clustering, (Cell)this.mergedData, (Cell)input);
                        continue;
                    }
                    ComplexColumnData mergedData = (ComplexColumnData)this.mergedData;
                    ComplexColumnData inputData = (ComplexColumnData)input;
                    if (mergedData == null) {
                        if (!inputData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, this.val$clustering, column, null, inputData.complexDeletion());
                        }
                        for (Cell<?> inputCell : inputData) {
                            diffListener.onCell(i, this.val$clustering, null, inputCell);
                        }
                        continue;
                    }
                    if (inputData == null) {
                        if (!mergedData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, this.val$clustering, column, mergedData.complexDeletion(), null);
                        }
                        for (Cell<?> mergedCell : mergedData) {
                            diffListener.onCell(i, this.val$clustering, mergedCell, null);
                        }
                        continue;
                    }
                    if (!mergedData.complexDeletion().isLive() || !inputData.complexDeletion().isLive()) {
                        diffListener.onComplexDeletion(i, this.val$clustering, column, mergedData.complexDeletion(), inputData.complexDeletion());
                    }
                    PeekingIterator<Cell<?>> mergedCells = Iterators.peekingIterator(mergedData.iterator());
                    PeekingIterator<Cell<?>> inputCells = Iterators.peekingIterator(inputData.iterator());
                    while (mergedCells.hasNext() && inputCells.hasNext()) {
                        int cmp = column.cellPathComparator().compare(mergedCells.peek().path(), inputCells.peek().path());
                        if (cmp == 0) {
                            diffListener.onCell(i, this.val$clustering, mergedCells.next(), inputCells.next());
                            continue;
                        }
                        if (cmp < 0) {
                            diffListener.onCell(i, this.val$clustering, mergedCells.next(), null);
                            continue;
                        }
                        diffListener.onCell(i, this.val$clustering, null, inputCells.next());
                    }
                    while (mergedCells.hasNext()) {
                        diffListener.onCell(i, this.val$clustering, mergedCells.next(), null);
                    }
                    while (inputCells.hasNext()) {
                        diffListener.onCell(i, this.val$clustering, null, inputCells.next());
                    }
                }
                return null;
            }

            @Override
            protected void onKeyChange() {
                this.mergedData = null;
                Arrays.fill(this.inputDatas, null);
            }
        });
        while (iter2.hasNext()) {
            iter2.next();
        }
    }

    public static Row merge(Row existing, Row update) {
        return Rows.merge(existing, update, ColumnData.noOp);
    }

    public static Row merge(Row existing, Row update, ColumnData.PostReconciliationFunction onReconcile) {
        assert (existing instanceof BTreeRow);
        assert (update instanceof BTreeRow);
        return BTreeRow.merge((BTreeRow)existing, (BTreeRow)update, onReconcile);
    }

    public static Row removeShadowedCells(Row existing, Row update, DeletionTime rangeDeletion) {
        ColumnData nextb;
        Row.Deletion rowDeletion;
        LivenessInfo existingInfo;
        Row.Builder builder = BTreeRow.sortedBuilder();
        ClusteringPrefix clustering = existing.clustering();
        builder.newRow((Clustering<?>)clustering);
        DeletionTime deletion = update.deletion().time();
        if (rangeDeletion.supersedes(deletion)) {
            deletion = rangeDeletion;
        }
        if (!deletion.deletes(existingInfo = existing.primaryKeyLivenessInfo())) {
            builder.addPrimaryKeyLivenessInfo(existingInfo);
        }
        if (!deletion.supersedes((rowDeletion = existing.deletion()).time())) {
            builder.addRowDeletion(rowDeletion);
        }
        Iterator a = existing.iterator();
        Iterator b = update.iterator();
        ColumnData nexta = a.hasNext() ? (ColumnData)a.next() : null;
        ColumnData columnData = nextb = b.hasNext() ? (ColumnData)b.next() : null;
        while (nexta != null) {
            int comparison;
            int n = comparison = nextb == null ? -1 : nexta.column.compareTo(nextb.column);
            if (comparison <= 0) {
                ColumnData curb;
                ColumnData cura = nexta;
                ColumnMetadata column = cura.column;
                ColumnData columnData2 = curb = comparison == 0 ? nextb : null;
                if (column.isSimple()) {
                    Cells.addNonShadowed((Cell)cura, (Cell)curb, deletion, builder);
                } else {
                    DeletionTime maxDt;
                    ComplexColumnData existingData = (ComplexColumnData)cura;
                    ComplexColumnData updateData = (ComplexColumnData)curb;
                    DeletionTime existingDt = existingData.complexDeletion();
                    DeletionTime updateDt = updateData == null ? DeletionTime.LIVE : updateData.complexDeletion();
                    DeletionTime deletionTime = maxDt = updateDt.supersedes(deletion) ? updateDt : deletion;
                    if (existingDt.supersedes(maxDt)) {
                        builder.addComplexDeletion(column, existingDt);
                        maxDt = existingDt;
                    }
                    Iterator<Cell<?>> existingCells = existingData.iterator();
                    Iterator<Cell<?>> updateCells = updateData == null ? null : updateData.iterator();
                    Cells.addNonShadowedComplex(column, existingCells, updateCells, maxDt, builder);
                }
                ColumnData columnData3 = nexta = a.hasNext() ? (ColumnData)a.next() : null;
                if (curb == null) continue;
                nextb = b.hasNext() ? (ColumnData)b.next() : null;
                continue;
            }
            nextb = b.hasNext() ? (ColumnData)b.next() : null;
        }
        Row row = builder.build();
        return row != null && !row.isEmpty() ? row : null;
    }

    private static class StatsAccumulation {
        private static final long COLUMN_INCR = 0x100000000L;
        private static final long CELL_INCR = 1L;

        private StatsAccumulation() {
        }

        private static long accumulateOnCell(PartitionStatisticsCollector collector, Cell<?> cell, long l) {
            Cells.collectStats(cell, collector);
            return l + 1L;
        }

        private static long accumulateOnColumnData(PartitionStatisticsCollector collector, ColumnData cd2, long l) {
            if (cd2.column().isSimple()) {
                l = StatsAccumulation.accumulateOnCell(collector, (Cell)cd2, l) + 0x100000000L;
            } else {
                ComplexColumnData complexData = (ComplexColumnData)cd2;
                collector.update(complexData.complexDeletion());
                int startingCells = StatsAccumulation.unpackCellCount(l);
                l = complexData.accumulate(StatsAccumulation::accumulateOnCell, collector, l);
                if (StatsAccumulation.unpackCellCount(l) > startingCells) {
                    l += 0x100000000L;
                }
            }
            return l;
        }

        private static int unpackCellCount(long v) {
            return (int)(v & 0xFFFFFFFFL);
        }

        private static int unpackColumnCount(long v) {
            return (int)(v >>> 32);
        }
    }
}

