/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.github.jamm.Unmetered;

public abstract class AbstractMemtable
implements Memtable {
    private final AtomicReference<LifecycleTransaction> flushTransaction = new AtomicReference<Object>(null);
    protected final AtomicLong currentOperations = new AtomicLong(0L);
    protected final ColumnsCollector columnsCollector;
    protected final StatsCollector statsCollector = new StatsCollector();
    protected AtomicLong minTimestamp = new AtomicLong(Long.MAX_VALUE);
    protected AtomicLong minLocalDeletionTime = new AtomicLong(Long.MAX_VALUE);
    @Unmetered
    protected TableMetadataRef metadata;

    public AbstractMemtable(TableMetadataRef metadataRef) {
        this.metadata = metadataRef;
        this.columnsCollector = new ColumnsCollector(this.metadata.get().regularAndStaticColumns());
    }

    @VisibleForTesting
    public AbstractMemtable(TableMetadataRef metadataRef, long minTimestamp) {
        this.metadata = metadataRef;
        this.columnsCollector = new ColumnsCollector(this.metadata.get().regularAndStaticColumns());
        this.minTimestamp = new AtomicLong(minTimestamp);
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata.get();
    }

    @Override
    public long operationCount() {
        return this.currentOperations.get();
    }

    @Override
    public long getMinTimestamp() {
        return this.minTimestamp.get() != EncodingStats.NO_STATS.minTimestamp ? this.minTimestamp.get() : -1L;
    }

    @Override
    public long getMinLocalDeletionTime() {
        return this.minLocalDeletionTime.get();
    }

    protected static void updateMin(AtomicLong minTracker, long newValue) {
        long existing;
        while ((existing = minTracker.get()) > newValue && !minTracker.compareAndSet(existing, newValue)) {
        }
    }

    protected static void updateMin(AtomicInteger minTracker, int newValue) {
        int existing;
        while ((existing = minTracker.get()) > newValue && !minTracker.compareAndSet(existing, newValue)) {
        }
    }

    RegularAndStaticColumns columns() {
        return this.columnsCollector.get();
    }

    EncodingStats encodingStats() {
        return this.statsCollector.get();
    }

    @Override
    public LifecycleTransaction getFlushTransaction() {
        return this.flushTransaction.get();
    }

    @Override
    public LifecycleTransaction setFlushTransaction(LifecycleTransaction flushTransaction) {
        return this.flushTransaction.getAndSet(flushTransaction);
    }

    protected abstract class AbstractFlushablePartitionSet<P extends Partition>
    implements Memtable.FlushablePartitionSet<P> {
        protected AbstractFlushablePartitionSet() {
        }

        @Override
        public long dataSize() {
            return AbstractMemtable.this.getLiveDataSize();
        }

        @Override
        public CommitLogPosition commitLogLowerBound() {
            return AbstractMemtable.this.getCommitLogLowerBound();
        }

        @Override
        public Memtable.LastCommitLogPosition commitLogUpperBound() {
            return AbstractMemtable.this.getFinalCommitLogUpperBound();
        }

        @Override
        public EncodingStats encodingStats() {
            return AbstractMemtable.this.encodingStats();
        }

        @Override
        public RegularAndStaticColumns columns() {
            return AbstractMemtable.this.columns();
        }
    }

    protected static class StatsCollector {
        private final AtomicReference<EncodingStats> stats = new AtomicReference<EncodingStats>(EncodingStats.NO_STATS);

        protected StatsCollector() {
        }

        public void update(EncodingStats newStats) {
            EncodingStats updated;
            EncodingStats current;
            while (!this.stats.compareAndSet(current = this.stats.get(), updated = current.mergeWith(newStats))) {
            }
        }

        public EncodingStats get() {
            return this.stats.get();
        }
    }

    protected static class ColumnsCollector {
        private final HashMap<ColumnMetadata, AtomicBoolean> predefined = new HashMap();
        private final ConcurrentSkipListSet<ColumnMetadata> extra = new ConcurrentSkipListSet();

        ColumnsCollector(RegularAndStaticColumns columns) {
            for (ColumnMetadata def : columns.statics) {
                this.predefined.put(def, new AtomicBoolean());
            }
            for (ColumnMetadata def : columns.regulars) {
                this.predefined.put(def, new AtomicBoolean());
            }
        }

        public void update(RegularAndStaticColumns columns) {
            for (ColumnMetadata s2 : columns.statics) {
                this.update(s2);
            }
            for (ColumnMetadata r : columns.regulars) {
                this.update(r);
            }
        }

        public void update(ColumnsCollector other) {
            for (Map.Entry<ColumnMetadata, AtomicBoolean> v : other.predefined.entrySet()) {
                if (!v.getValue().get()) continue;
                this.update(v.getKey());
            }
            this.extra.addAll(other.extra);
        }

        private void update(ColumnMetadata definition) {
            AtomicBoolean present = this.predefined.get(definition);
            if (present != null) {
                if (!present.get()) {
                    present.set(true);
                }
            } else {
                this.extra.add(definition);
            }
        }

        public RegularAndStaticColumns get() {
            RegularAndStaticColumns.Builder builder = RegularAndStaticColumns.builder();
            for (Map.Entry<ColumnMetadata, AtomicBoolean> e : this.predefined.entrySet()) {
                if (!e.getValue().get()) continue;
                builder.add(e.getKey());
            }
            return builder.addAll(this.extra).build();
        }
    }
}

