/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.transport.ProtocolVersion;

final class ScalarFunctionSelector
extends AbstractFunctionSelector<ScalarFunction> {
    static final Selector.SelectorDeserializer deserializer = new AbstractFunctionSelector.AbstractFunctionSelectorDeserializer(){

        @Override
        protected Selector newFunctionSelector(ProtocolVersion version, Function function, List<Selector> argSelectors) {
            return new ScalarFunctionSelector(version, function, argSelectors);
        }
    };

    @Override
    public void addInput(Selector.InputRow input) {
        int m4 = this.argSelectors.size();
        for (int i = 0; i < m4; ++i) {
            Selector s2 = (Selector)this.argSelectors.get(i);
            s2.addInput(input);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        int m4 = this.argSelectors.size();
        for (int i = 0; i < m4; ++i) {
            Selector s2 = (Selector)this.argSelectors.get(i);
            this.setArg(i, s2.getOutput(protocolVersion));
            s2.reset();
        }
        return ((ScalarFunction)this.fun).execute(this.args());
    }

    @Override
    public void validateForGroupBy() {
        RequestValidations.checkTrue(((ScalarFunction)this.fun).isMonotonic(), "Only monotonic functions are supported in the GROUP BY clause. Got: %s ", this.fun);
        int m4 = this.argSelectors.size();
        for (int i = 0; i < m4; ++i) {
            ((Selector)this.argSelectors.get(i)).validateForGroupBy();
        }
    }

    ScalarFunctionSelector(ProtocolVersion version, Function fun, List<Selector> argSelectors) {
        super(Selector.Kind.SCALAR_FUNCTION_SELECTOR, version, (ScalarFunction)fun, argSelectors);
    }
}

