/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener dbg, TreeAdaptor adaptor) {
        this.dbg = dbg;
        this.adaptor = adaptor;
    }

    public Object create(Token payload) {
        if (payload.getTokenIndex() < 0) {
            return this.create(payload.getType(), payload.getText());
        }
        Object node = this.adaptor.create(payload);
        this.dbg.createNode(node, payload);
        return node;
    }

    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
        Object node = this.adaptor.errorNode(input, start, stop, e);
        if (node != null) {
            this.dbg.errorNode(node);
        }
        return node;
    }

    public Object dupTree(Object tree) {
        Object t2 = this.adaptor.dupTree(tree);
        this.simulateTreeConstruction(t2);
        return t2;
    }

    protected void simulateTreeConstruction(Object t2) {
        this.dbg.createNode(t2);
        int n = this.adaptor.getChildCount(t2);
        for (int i = 0; i < n; ++i) {
            Object child = this.adaptor.getChild(t2, i);
            this.simulateTreeConstruction(child);
            this.dbg.addChild(t2, child);
        }
    }

    public Object dupNode(Object treeNode) {
        Object d = this.adaptor.dupNode(treeNode);
        this.dbg.createNode(d);
        return d;
    }

    public Object nil() {
        Object node = this.adaptor.nil();
        this.dbg.nilNode(node);
        return node;
    }

    public boolean isNil(Object tree) {
        return this.adaptor.isNil(tree);
    }

    public void addChild(Object t2, Object child) {
        if (t2 == null || child == null) {
            return;
        }
        this.adaptor.addChild(t2, child);
        this.dbg.addChild(t2, child);
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Object n = this.adaptor.becomeRoot(newRoot, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    public Object rulePostProcessing(Object root) {
        return this.adaptor.rulePostProcessing(root);
    }

    public void addChild(Object t2, Token child) {
        Object n = this.create(child);
        this.addChild(t2, n);
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        Object n = this.create(newRoot);
        this.adaptor.becomeRoot(n, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    public Object create(int tokenType, Token fromToken) {
        Object node = this.adaptor.create(tokenType, fromToken);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        Object node = this.adaptor.create(tokenType, fromToken, text);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, String text) {
        Object node = this.adaptor.create(tokenType, text);
        this.dbg.createNode(node);
        return node;
    }

    public int getType(Object t2) {
        return this.adaptor.getType(t2);
    }

    public void setType(Object t2, int type) {
        this.adaptor.setType(t2, type);
    }

    public String getText(Object t2) {
        return this.adaptor.getText(t2);
    }

    public void setText(Object t2, String text) {
        this.adaptor.setText(t2, text);
    }

    public Token getToken(Object t2) {
        return this.adaptor.getToken(t2);
    }

    public void setTokenBoundaries(Object t2, Token startToken, Token stopToken) {
        this.adaptor.setTokenBoundaries(t2, startToken, stopToken);
        if (t2 != null && startToken != null && stopToken != null) {
            this.dbg.setTokenBoundaries(t2, startToken.getTokenIndex(), stopToken.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object t2) {
        return this.adaptor.getTokenStartIndex(t2);
    }

    public int getTokenStopIndex(Object t2) {
        return this.adaptor.getTokenStopIndex(t2);
    }

    public Object getChild(Object t2, int i) {
        return this.adaptor.getChild(t2, i);
    }

    public void setChild(Object t2, int i, Object child) {
        this.adaptor.setChild(t2, i, child);
    }

    public Object deleteChild(Object t2, int i) {
        return this.deleteChild(t2, i);
    }

    public int getChildCount(Object t2) {
        return this.adaptor.getChildCount(t2);
    }

    public int getUniqueID(Object node) {
        return this.adaptor.getUniqueID(node);
    }

    public Object getParent(Object t2) {
        return this.adaptor.getParent(t2);
    }

    public int getChildIndex(Object t2) {
        return this.adaptor.getChildIndex(t2);
    }

    public void setParent(Object t2, Object parent) {
        this.adaptor.setParent(t2, parent);
    }

    public void setChildIndex(Object t2, int index) {
        this.adaptor.setChildIndex(t2, index);
    }

    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t2) {
        this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t2);
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void setDebugListener(DebugEventListener dbg) {
        this.dbg = dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

