/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.IgnoresEverything;
import org.jetbrains.annotations.NotNull;

public final class Mocker {
    private static final Class<?>[] NO_CLASSES = new Class[0];

    private Mocker() {
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintStream out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull PrintWriter out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> tClass, String description, @NotNull StringWriter out) {
        return Mocker.logging(tClass, description, new PrintWriter(out));
    }

    @NotNull
    public static <T> T queuing(@NotNull Class<T> tClass, String description, @NotNull BlockingQueue<String> queue) {
        return Mocker.intercepting(tClass, description, queue::add);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, String description, @NotNull Consumer<String> consumer) {
        return Mocker.intercepting(tClass, description, consumer, null);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, @NotNull String description, @NotNull Consumer<String> consumer, T t2) {
        return Mocker.intercepting(tClass, (String name, Object[] args) -> consumer.accept(description + name + (args == null ? "()" : Arrays.toString(args))), t2);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> tClass, final @NotNull BiConsumer<String, Object[]> consumer, final T t2) {
        LinkedHashSet classes = new LinkedHashSet();
        Mocker.addInterface(classes, tClass);
        return (T)Mocker.newProxyInstance(tClass.getClassLoader(), classes.toArray(NO_CLASSES), new AbstractInvocationHandler(tClass){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
                consumer.accept(method.getName(), args);
                try {
                    if (t2 != null) {
                        return method.invoke(t2, args);
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    private static <T> void addInterface(Set<Class<?>> classes, Class<T> tClass) {
        if (Jvm.dontChain(tClass)) {
            return;
        }
        if (classes.contains(tClass)) {
            return;
        }
        classes.add(tClass);
        for (Method method : tClass.getMethods()) {
            Class returnType;
            Type returnType0 = GenericReflection.getReturnType(method, tClass);
            if (!(returnType0 instanceof Class) || !(returnType = (Class)returnType0).isInterface()) continue;
            Mocker.addInterface(classes, returnType);
        }
    }

    @NotNull
    public static <T> T ignored(@NotNull Class<T> tClass, Class<?> ... additional) {
        LinkedHashSet classes = new LinkedHashSet();
        Mocker.addInterface(classes, tClass);
        classes.add(tClass);
        for (Class<?> aClass : additional) {
            Mocker.addInterface(classes, aClass);
        }
        classes.add(IgnoresEverything.class);
        ClassLoader tClassLoader = tClass.getClassLoader();
        return (T)Mocker.newProxyInstance(tClassLoader != null ? tClassLoader : Mocker.class.getClassLoader(), classes.toArray(NO_CLASSES), new AbstractInvocationHandler(tClass){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) {
                return null;
            }
        });
    }

    private static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classes, AbstractInvocationHandler handler) {
        try {
            return Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            try {
                return Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), classes, (InvocationHandler)handler);
            }
            catch (IllegalArgumentException e2) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

