/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

public class BinaryIntReference
extends AbstractReference
implements IntValue {
    public static final int INT_NOT_COMPLETE = Integer.MIN_VALUE;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (bytes instanceof HexDumpBytes) {
            offset &= 0xFFFFFFFFL;
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 4L;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "bytes is null";
        }
        try {
            return "value: " + this.getValue();
        }
        catch (Throwable e) {
            return "value: " + e;
        }
    }

    @Override
    public int getValue() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes == null ? 0 : this.bytes.readInt(this.offset);
    }

    @Override
    public void setValue(int value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeInt(this.offset, value);
    }

    @Override
    public int getVolatileValue() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileInt(this.offset);
    }

    @Override
    public void setOrderedValue(int value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeOrderedInt(this.offset, value);
    }

    @Override
    public int addValue(int delta) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytes.addAndGetInt(this.offset, delta);
    }

    @Override
    public int addAtomicValue(int delta) throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(int expected, int value) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        return this.bytes.compareAndSwapInt(this.offset, expected, value);
    }
}

