/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.DefaultVectorizationProvider;
import io.github.jbellis.jvector.vector.VectorUtilSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class VectorizationProvider {
    protected static final Logger LOG = Logger.getLogger(VectorizationProvider.class.getName());
    private static final Runtime.Version VERSION_JDK8301190_FIXED = Runtime.Version.parse("20.0.2");

    public static VectorizationProvider getInstance() {
        return Objects.requireNonNull(Holder.INSTANCE, "call to getInstance() from subclass of VectorizationProvider");
    }

    protected VectorizationProvider() {
    }

    public abstract VectorUtilSupport getVectorUtilSupport();

    static VectorizationProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 20 && runtimeVersion <= 21) {
            if (VectorizationProvider.isAffectedByJDK8301190()) {
                LOG.warning("Java runtime is using a buggy default locale; Java vector incubator API can't be enabled: " + String.valueOf(Locale.getDefault()));
                return new DefaultVectorizationProvider();
            }
            if (!VectorizationProvider.vectorModulePresentAndReadable()) {
                LOG.warning("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new DefaultVectorizationProvider();
            }
            if (!testMode && VectorizationProvider.isClientVM()) {
                LOG.warning("C2 compiler is disabled; Java vector incubator API can't be enabled");
                return new DefaultVectorizationProvider();
            }
            try {
                VectorizationProvider provider = (VectorizationProvider)Class.forName("io.github.jbellis.jvector.vector.PanamaVectorizationProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
                LOG.info("Java incubating Vector API enabled. Using PanamaVectorizationProvider.");
                return provider;
            }
            catch (UnsupportedOperationException uoe) {
                LOG.warning("Java vector API was not enabled. " + uoe.getMessage());
                return new DefaultVectorizationProvider();
            }
            catch (ClassNotFoundException e) {
                LOG.warning("Java version does not support vector API");
                return new DefaultVectorizationProvider();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable th) {
                throw new AssertionError((Object)th);
            }
        }
        if (runtimeVersion >= 22) {
            LOG.warning("You are running with Java 22 or later. To make full use of the Vector API, please update jvector.");
        } else {
            LOG.warning("You are running with Java 19 or earlier, which do not support the required incubating Vector API. Falling back to slower defaults.");
        }
        return new DefaultVectorizationProvider();
    }

    static boolean vectorModulePresentAndReadable() {
        Optional<Module> opt = ModuleLayer.boot().modules().stream().filter(m4 -> m4.getName().equals("jdk.incubator.vector")).findFirst();
        if (opt.isPresent()) {
            VectorizationProvider.class.getModule().addReads(opt.get());
            return true;
        }
        return false;
    }

    private static boolean isAffectedByJDK8301190() {
        return VERSION_JDK8301190_FIXED.compareToIgnoreOptional(Runtime.version()) > 0 && !Objects.equals("I", "i".toUpperCase(Locale.getDefault()));
    }

    private static boolean isClientVM() {
        try {
            PrivilegedAction<Boolean> action = () -> System.getProperty("java.vm.info", "").contains("emulated-client");
            return AccessController.doPrivileged(action);
        }
        catch (SecurityException e) {
            LOG.warning("SecurityManager denies permission to 'java.vm.info' system property, so state of C2 compiler can't be detected. In case of performance issues allow access to this property.");
            return false;
        }
    }

    private static final class Holder {
        static final VectorizationProvider INSTANCE = VectorizationProvider.lookup(false);

        private Holder() {
        }
    }
}

