/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec;

import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import com.datastax.shaded.netty.channel.ChannelPromise;
import com.datastax.shaded.netty.handler.codec.CodecOutputList;
import com.datastax.shaded.netty.handler.codec.EncoderException;
import com.datastax.shaded.netty.util.ReferenceCountUtil;
import com.datastax.shaded.netty.util.concurrent.PromiseCombiner;
import com.datastax.shaded.netty.util.internal.PlatformDependent;
import com.datastax.shaded.netty.util.internal.StringUtil;
import com.datastax.shaded.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        block21: {
            CodecOutputList out = null;
            try {
                if (this.acceptOutboundMessage(msg)) {
                    out = CodecOutputList.newInstance();
                    Object cast = msg;
                    try {
                        this.encode(ctx, cast, out);
                    }
                    catch (Throwable th) {
                        ReferenceCountUtil.safeRelease(cast);
                        PlatformDependent.throwException(th);
                    }
                    ReferenceCountUtil.release(cast);
                    if (out.isEmpty()) {
                        throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                    }
                    break block21;
                }
                ctx.write(msg, promise);
            }
            catch (EncoderException e) {
                throw e;
            }
            catch (Throwable t2) {
                throw new EncoderException(t2);
            }
            finally {
                if (out != null) {
                    try {
                        int sizeMinusOne = out.size() - 1;
                        if (sizeMinusOne == 0) {
                            ctx.write(out.getUnsafe(0), promise);
                        } else if (sizeMinusOne > 0) {
                            if (promise == ctx.voidPromise()) {
                                MessageToMessageEncoder.writeVoidPromise(ctx, out);
                            } else {
                                MessageToMessageEncoder.writePromiseCombiner(ctx, out, promise);
                            }
                        }
                    }
                    finally {
                        out.recycle();
                    }
                }
            }
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext ctx, CodecOutputList out) {
        ChannelPromise voidPromise = ctx.voidPromise();
        for (int i = 0; i < out.size(); ++i) {
            ctx.write(out.getUnsafe(i), voidPromise);
        }
    }

    private static void writePromiseCombiner(ChannelHandlerContext ctx, CodecOutputList out, ChannelPromise promise) {
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        for (int i = 0; i < out.size(); ++i) {
            combiner.add(ctx.write(out.getUnsafe(i)));
        }
        combiner.finish(promise);
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

