/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Long>> gauges = new HashMap<String, Gauge<Long>>();
        gauges.put("total.init", () -> this.mxBean.getHeapMemoryUsage().getInit() + this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put("total.used", () -> this.mxBean.getHeapMemoryUsage().getUsed() + this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put("total.max", () -> this.mxBean.getNonHeapMemoryUsage().getMax() == -1L ? -1L : this.mxBean.getHeapMemoryUsage().getMax() + this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put("total.committed", () -> this.mxBean.getHeapMemoryUsage().getCommitted() + this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put("heap.init", () -> this.mxBean.getHeapMemoryUsage().getInit());
        gauges.put("heap.used", () -> this.mxBean.getHeapMemoryUsage().getUsed());
        gauges.put("heap.max", () -> this.mxBean.getHeapMemoryUsage().getMax());
        gauges.put("heap.committed", () -> this.mxBean.getHeapMemoryUsage().getCommitted());
        gauges.put("heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax());
            }
        });
        gauges.put("non-heap.init", () -> this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put("non-heap.used", () -> this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put("non-heap.max", () -> this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put("non-heap.committed", () -> this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put("non-heap.usage", new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = MetricRegistry.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("-"));
            gauges.put(MetricRegistry.name(poolName, "usage"), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage usage = pool.getUsage();
                    return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
                }
            });
            gauges.put(MetricRegistry.name(poolName, "max"), () -> pool.getUsage().getMax());
            gauges.put(MetricRegistry.name(poolName, "used"), () -> pool.getUsage().getUsed());
            gauges.put(MetricRegistry.name(poolName, "committed"), () -> pool.getUsage().getCommitted());
            if (pool.getCollectionUsage() != null) {
                gauges.put(MetricRegistry.name(poolName, "used-after-gc"), () -> pool.getCollectionUsage().getUsed());
            }
            gauges.put(MetricRegistry.name(poolName, "init"), () -> pool.getUsage().getInit());
        }
        return Collections.unmodifiableMap(gauges);
    }
}

