/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.hash;

public class MurmurHash {
    public static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Long) {
            return MurmurHash.hashLong((Long)o);
        }
        if (o instanceof Integer) {
            return MurmurHash.hashLong(((Integer)o).intValue());
        }
        if (o instanceof Double) {
            return MurmurHash.hashLong(Double.doubleToRawLongBits((Double)o));
        }
        if (o instanceof Float) {
            return MurmurHash.hashLong(Float.floatToRawIntBits(((Float)o).floatValue()));
        }
        if (o instanceof String) {
            return MurmurHash.hash(((String)o).getBytes());
        }
        if (o instanceof byte[]) {
            return MurmurHash.hash((byte[])o);
        }
        return MurmurHash.hash(o.toString());
    }

    public static int hash(byte[] data) {
        return MurmurHash.hash(data, data.length, -1);
    }

    public static int hash(byte[] data, int seed) {
        return MurmurHash.hash(data, data.length, seed);
    }

    public static int hash(byte[] data, int length, int seed) {
        int m4 = 1540483477;
        int r = 24;
        int h2 = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m4;
            k ^= k >>> r;
            h2 *= m4;
            h2 ^= (k *= m4);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h2 ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h2 ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h2 ^= data[length - 1];
            }
            h2 *= m4;
        }
        h2 ^= h2 >>> 13;
        h2 *= m4;
        h2 ^= h2 >>> 15;
        return h2;
    }

    public static int hashLong(long data) {
        int m4 = 1540483477;
        int r = 24;
        int h2 = 0;
        int k = (int)data * m4;
        k ^= k >>> r;
        h2 ^= k * m4;
        k = (int)(data >> 32) * m4;
        k ^= k >>> r;
        h2 *= m4;
        h2 ^= k * m4;
        h2 ^= h2 >>> 13;
        h2 *= m4;
        h2 ^= h2 >>> 15;
        return h2;
    }

    public static long hash64(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof String) {
            byte[] bytes = ((String)o).getBytes();
            return MurmurHash.hash64(bytes, bytes.length);
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return MurmurHash.hash64(bytes, bytes.length);
        }
        return MurmurHash.hash64(o.toString());
    }

    public static long hash64(byte[] data, int length) {
        return MurmurHash.hash64(data, length, -512093083);
    }

    public static long hash64(byte[] data, int length, int seed) {
        long m4 = -4132994306676758123L;
        int r = 47;
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h2 ^= (k *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h2 ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }
}

