/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing;

import java.math.BigInteger;

public enum Partitioner {
    Murmur3(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)),
    Random(BigInteger.ONE.negate(), BigInteger.valueOf(2L).pow(127));

    public final BigInteger minToken;
    public final BigInteger maxToken;

    private Partitioner(BigInteger minToken, BigInteger maxToken) {
        this.minToken = minToken;
        this.maxToken = maxToken;
    }

    public static Partitioner fromClassName(String className) {
        switch (className) {
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return Murmur3;
            }
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return Random;
            }
        }
        throw new UnsupportedOperationException("Unexpected partitioner: " + className);
    }
}

