/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing;

import com.google.common.annotations.VisibleForTesting;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.shared.Versions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.IClusterExtension;
import org.apache.cassandra.testing.TestVersion;
import org.assertj.core.api.Assertions;

public class IsolatedDTestClassLoaderWrapper {
    protected DTestJarClassLoader dtestJarClassLoader;

    public void initializeDTestJarClassLoader(TestVersion testVersion, Class<?> clazz) {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        Semver version = new Semver(testVersion.version(), Semver.SemverType.LOOSE);
        ArrayList<URL> urlList = new ArrayList<URL>(Arrays.asList(Versions.find().getLatest((Semver)version).classpath));
        URL classUrl = IsolatedDTestClassLoaderWrapper.urlOfClass(clazz);
        urlList.add(classUrl);
        this.dtestJarClassLoader = new DTestJarClassLoader(urlList.toArray(new URL[0]), parent);
    }

    public void closeDTestJarClassLoader() {
        if (this.dtestJarClassLoader != null) {
            try {
                this.dtestJarClassLoader.close();
            }
            catch (IOException ioException) {
                throw new UncheckedIOException("Failed to close custom class loader", ioException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeActionOnDTestClassLoader(ExecutableAction<T> action) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.dtestJarClassLoader);
            T t = action.run();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void executeExceptionableActionOnDTestClassLoader(ExecutableExceptionableAction<T> action) throws IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.dtestJarClassLoader);
            action.run();
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public IClusterExtension<? extends IInstance> loadCluster(String versionString, ClusterBuilderConfiguration builderConfiguration) {
        return this.executeActionOnDTestClassLoader(() -> {
            try {
                Class<?> launcherClass = Class.forName("org.apache.cassandra.distributed.impl.CassandraCluster", true, this.dtestJarClassLoader);
                Constructor<?> ctor = launcherClass.getDeclaredConstructor(String.class, ClusterBuilderConfiguration.class);
                return (IClusterExtension)ctor.newInstance(versionString, builderConfiguration);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to provision cluster for version " + versionString, e);
            }
        });
    }

    static URL urlOfClass(Class<?> clazz) {
        URL classUrl = clazz.getResource(clazz.getSimpleName() + ".class");
        Assertions.assertThat((URL)classUrl).isNotNull();
        String pathOfClassInJar = "!/" + clazz.getCanonicalName().replace(".", "/") + ".class";
        String classDir = classUrl.getPath().replace(pathOfClassInJar, "");
        try {
            return new URL(classDir);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ExecutableExceptionableAction<T> {
        public T run() throws IOException;
    }

    public static interface ExecutableAction<T> {
        public T run();
    }

    @VisibleForTesting
    public static class DTestJarClassLoader
    extends URLClassLoader {
        DTestJarClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!"org.apache.cassandra.distributed.impl.CassandraCluster".equals(name)) {
                return super.loadClass(name, resolve);
            }
            Class<?> type = this.findLoadedClass(name);
            if (type == null) {
                try {
                    type = this.findClass(name);
                }
                catch (ClassNotFoundException | LinkageError | SecurityException throwable) {
                    // empty catch block
                }
                if (type == null) {
                    type = super.loadClass(name, false);
                }
            }
            if (resolve) {
                this.resolveClass(type);
            }
            return type;
        }
    }
}

