/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.testing;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryCqlSessionProvider
implements CQLSessionProvider {
    private static final Logger logger = LoggerFactory.getLogger(TemporaryCqlSessionProvider.class);
    private final List<InetSocketAddress> contactPoints;
    private Session localSession;
    private final NettyOptions nettyOptions;
    private final ReconnectionPolicy reconnectionPolicy;

    public TemporaryCqlSessionProvider(List<InetSocketAddress> contactPoints, NettyOptions options) {
        this.nettyOptions = options;
        this.reconnectionPolicy = new ExponentialReconnectionPolicy(100L, 1000L);
        this.contactPoints = contactPoints;
    }

    @Nullable
    public synchronized Session get() {
        block5: {
            Cluster cluster = null;
            try {
                if (this.localSession == null) {
                    logger.info("Connecting to {}", this.contactPoints);
                    cluster = Cluster.builder().addContactPointsWithPorts(this.contactPoints).withReconnectionPolicy(this.reconnectionPolicy).withoutMetrics().withNettyOptions(this.nettyOptions).build();
                    this.localSession = cluster.connect();
                    logger.info("Successfully connected to Cassandra instance!");
                }
            }
            catch (Exception e) {
                logger.error("Failed to reach Cassandra", (Throwable)e);
                if (cluster == null) break block5;
                try {
                    cluster.close();
                }
                catch (Exception ex) {
                    logger.error("Failed to close cluster in cleanup", (Throwable)ex);
                }
            }
        }
        return this.localSession;
    }

    public Session getIfConnected() {
        return this.localSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Session localSession;
        TemporaryCqlSessionProvider temporaryCqlSessionProvider = this;
        synchronized (temporaryCqlSessionProvider) {
            localSession = this.localSession;
            this.localSession = null;
        }
        if (localSession != null) {
            try {
                localSession.getCluster().closeAsync().get(1L, TimeUnit.MINUTES);
                localSession.closeAsync().get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                logger.warn("Unable to close session after 1 minute for provider {}", (Object)this, (Object)e);
            }
            catch (ExecutionException e) {
                throw TemporaryCqlSessionProvider.propagateCause(e);
            }
        }
    }

    static RuntimeException propagateCause(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof DriverException) {
            throw ((DriverException)cause).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", cause);
    }
}

