/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.testing;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.util.Modules;
import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.IInstanceConfig;
import org.apache.cassandra.distributed.shared.JMXUtil;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.InstancesMetadataImpl;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadataImpl;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SidecarVersionProvider;
import org.apache.cassandra.sidecar.common.server.utils.ThrowableUtils;
import org.apache.cassandra.sidecar.config.ClusterLeaseClaimConfiguration;
import org.apache.cassandra.sidecar.config.CoordinationConfiguration;
import org.apache.cassandra.sidecar.config.JmxConfiguration;
import org.apache.cassandra.sidecar.config.KeyStoreConfiguration;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.S3ProxyConfiguration;
import org.apache.cassandra.sidecar.config.SSTableUploadConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.yaml.ClusterLeaseClaimConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.CoordinationConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.KeyStoreConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.S3ClientConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SSTableUploadConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SchemaKeyspaceConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.ServiceConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SidecarConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SslConfigurationImpl;
import org.apache.cassandra.sidecar.metrics.instance.InstanceHealthMetrics;
import org.apache.cassandra.sidecar.modules.SidecarModules;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.apache.cassandra.sidecar.testing.LocalhostResolver;
import org.apache.cassandra.sidecar.testing.MtlsTestHelper;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.sidecar.testing.SharedExecutorNettyOptions;
import org.apache.cassandra.sidecar.testing.TemporaryCqlSessionProvider;
import org.apache.cassandra.sidecar.utils.CassandraVersionProvider;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.IClusterExtension;
import org.apache.cassandra.testing.IsolatedDTestClassLoaderWrapper;
import org.apache.cassandra.testing.TestUtils;
import org.apache.cassandra.testing.TestVersion;
import org.apache.cassandra.testing.TestVersionSupplier;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={VertxExtension.class})
public abstract class SharedClusterIntegrationTestBase {
    protected final Logger logger = LoggerFactory.getLogger(SharedClusterIntegrationTestBase.class);
    private static final int MAX_CLUSTER_PROVISION_RETRIES = 5;
    @TempDir
    static Path secretsPath;
    protected DnsResolver dnsResolver = new LocalhostResolver();
    protected IClusterExtension<? extends IInstance> cluster;
    protected Server server;
    protected TestVersion testVersion;
    protected MtlsTestHelper mtlsTestHelper;
    private IsolatedDTestClassLoaderWrapper classLoaderWrapper;
    private Injector sidecarServerInjector;

    @BeforeAll
    protected void setup() throws Exception {
        Optional<TestVersion> maybeTestVersion = TestVersionSupplier.testVersions().findFirst();
        Assertions.assertThat(maybeTestVersion).isPresent();
        this.testVersion = maybeTestVersion.get();
        this.logger.info("Testing with Cassandra version={}", (Object)this.testVersion);
        this.classLoaderWrapper = new IsolatedDTestClassLoaderWrapper();
        this.classLoaderWrapper.initializeDTestJarClassLoader(this.testVersion, TestVersion.class);
        this.beforeClusterProvisioning();
        this.cluster = this.provisionClusterWithRetries(this.testVersion);
        Assertions.assertThat(this.cluster).isNotNull();
        this.afterClusterProvisioned();
        this.initializeSchemaForTest();
        this.mtlsTestHelper = new MtlsTestHelper(secretsPath);
        this.startSidecar(this.cluster);
        this.beforeTestStart();
    }

    private IClusterExtension<? extends IInstance> provisionClusterWithRetries(TestVersion testVersion) {
        for (int retry = 0; retry < 5; ++retry) {
            try {
                return this.classLoaderWrapper.loadCluster(testVersion.version(), this.testClusterConfiguration());
            }
            catch (RuntimeException runtimeException) {
                boolean addressAlreadyInUse;
                boolean bl = addressAlreadyInUse = ThrowableUtils.getCause((Throwable)runtimeException, ex -> ex instanceof BindException && ex.getMessage() != null && ex.getMessage().contains("Address already in use")) != null;
                if (!addressAlreadyInUse) {
                    throw runtimeException;
                }
                this.logger.warn("Failed to provision cluster after {} retries", (Object)retry, (Object)runtimeException);
                continue;
            }
        }
        throw new RuntimeException("Unable to provision cluster after 5 retries");
    }

    @AfterAll
    protected void tearDown() throws Exception {
        try {
            this.beforeSidecarStop();
            this.stopSidecar();
            this.beforeClusterShutdown();
            this.closeCluster();
            this.afterClusterShutdown();
        }
        finally {
            if (this.classLoaderWrapper != null) {
                this.classLoaderWrapper.closeDTestJarClassLoader();
            }
        }
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        ClusterBuilderConfiguration conf = new ClusterBuilderConfiguration();
        conf.additionalInstanceConfig(Map.of("storage_compatibility_mode", "NONE"));
        return conf;
    }

    protected void beforeClusterProvisioning() {
    }

    protected void afterClusterProvisioned() {
    }

    protected abstract void initializeSchemaForTest();

    protected void beforeTestStart() {
    }

    protected void beforeSidecarStop() {
    }

    protected void beforeClusterShutdown() {
    }

    protected void afterClusterShutdown() {
    }

    protected void createTestKeyspace(QualifiedName name, Map<String, Integer> rf) {
        this.createTestKeyspace(name.maybeQuotedKeyspace(), rf);
    }

    protected void createTestKeyspace(String keyspace, Map<String, Integer> rf) {
        this.cluster.schemaChangeIgnoringStoppedInstances("CREATE KEYSPACE IF NOT EXISTS " + keyspace + " WITH REPLICATION = { 'class' : 'NetworkTopologyStrategy', " + this.generateRfString(rf) + " };");
    }

    protected void createTestTable(QualifiedName name, String createTableStatement) {
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(createTableStatement, name));
    }

    protected Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> configurationOverrides() {
        return null;
    }

    protected void startSidecar(ICluster<? extends IInstance> cluster) throws InterruptedException {
        this.server = this.startSidecarWithInstances((Iterable<? extends IInstance>)cluster);
    }

    protected Server startSidecarWithInstances(Iterable<? extends IInstance> instances) throws InterruptedException {
        VertxTestContext context = new VertxTestContext();
        IntegrationTestModule testModule = new IntegrationTestModule(instances, this.classLoaderWrapper, this.mtlsTestHelper, this.dnsResolver, this.configurationOverrides());
        this.sidecarServerInjector = Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)SidecarModules.all()).with(new Module[]{testModule})});
        Server sidecarServer = (Server)this.sidecarServerInjector.getInstance(Server.class);
        sidecarServer.start().onSuccess(s -> context.completeNow()).onFailure(arg_0 -> ((VertxTestContext)context).failNow(arg_0));
        context.awaitCompletion(5L, TimeUnit.SECONDS);
        return sidecarServer;
    }

    protected void waitForSchemaReady(long timeout, TimeUnit timeUnit) {
        ((ObjectAssert)Assertions.assertThat((Object)this.sidecarServerInjector).describedAs("Sidecar is started", new Object[0])).isNotNull();
        CountDownLatch latch = new CountDownLatch(1);
        Vertx vertx = (Vertx)this.sidecarServerInjector.getInstance(Vertx.class);
        vertx.eventBus().localConsumer(SidecarServerEvents.ON_SIDECAR_SCHEMA_INITIALIZED.address(), msg -> latch.countDown());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)timeout, (TimeUnit)timeUnit)).describedAs("Sidecar schema is not initialized after " + timeout + " " + String.valueOf((Object)timeUnit), new Object[0])).isTrue();
    }

    protected void stopSidecar() throws InterruptedException {
        if (this.server == null) {
            return;
        }
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.server.close().onSuccess(res -> closeLatch.countDown());
        if (closeLatch.await(60L, TimeUnit.SECONDS)) {
            this.logger.info("Close event received before timeout.");
        } else {
            this.logger.error("Close event timed out.");
        }
    }

    protected void closeCluster() throws Exception {
        if (this.cluster == null) {
            return;
        }
        this.logger.info("Closing cluster={}", this.cluster);
        try {
            this.cluster.close();
        }
        catch (Throwable t) {
            if (Objects.equals(t.getClass().getCanonicalName(), "org.apache.cassandra.distributed.shared.ShutdownException")) {
                this.logger.debug("Encountered shutdown exception which closing the cluster", t);
            }
            throw t;
        }
    }

    protected String generateRfString(Map<String, Integer> rf) {
        return rf.entrySet().stream().map(entry -> String.format("'%s':%d", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
    }

    protected Object[][] queryAllData(QualifiedName table) {
        return this.queryAllData(table, org.apache.cassandra.distributed.api.ConsistencyLevel.LOCAL_QUORUM);
    }

    protected Object[][] queryAllData(QualifiedName table, org.apache.cassandra.distributed.api.ConsistencyLevel consistencyLevel) {
        return this.cluster.getFirstRunningInstance().coordinator().execute(String.format("SELECT * FROM %s;", table), consistencyLevel, new Object[0]);
    }

    protected ResultSet queryAllDataWithDriver(QualifiedName table) {
        return this.queryAllDataWithDriver(table, org.apache.cassandra.distributed.api.ConsistencyLevel.ALL);
    }

    protected ResultSet queryAllDataWithDriver(QualifiedName table, org.apache.cassandra.distributed.api.ConsistencyLevel consistency) {
        Cluster driverCluster = SharedClusterIntegrationTestBase.createDriverCluster(this.cluster.delegate());
        Session session = driverCluster.connect();
        SimpleStatement statement = new SimpleStatement(String.format("SELECT * FROM %s;", table));
        statement.setConsistencyLevel(ConsistencyLevel.valueOf((String)consistency.name()));
        return session.execute((Statement)statement);
    }

    public static Cluster createDriverCluster(ICluster<? extends IInstance> dtest) {
        dtest.stream().forEach(i -> {
            if (!i.config().has(Feature.NATIVE_PROTOCOL) || !i.config().has(Feature.GOSSIP)) {
                throw new IllegalStateException("Java driver requires Feature.NATIVE_PROTOCOL and Feature.GOSSIP; but one or more is missing");
            }
        });
        Cluster.Builder builder = Cluster.builder().withoutMetrics();
        dtest.stream().forEach(i -> {
            InetSocketAddress address = new InetSocketAddress(i.broadcastAddress().getAddress(), i.config().getInt("native_transport_port"));
            builder.addContactPointsWithPorts(new InetSocketAddress[]{address});
        });
        return builder.build();
    }

    protected JmxClient wrapJmxClient(JmxClient.Builder builder) {
        return new JmxClientProxy(this.classLoaderWrapper, builder);
    }

    static {
        TestUtils.configureDefaultDTestJarProperties();
    }

    static class JmxClientProxy
    extends JmxClient {
        private final IsolatedDTestClassLoaderWrapper wrapper;

        protected JmxClientProxy(IsolatedDTestClassLoaderWrapper wrapper, JmxClient.Builder builder) {
            super(Objects.requireNonNull(builder, "builder must be provided"));
            this.wrapper = wrapper;
        }

        protected void connectInternal(int currentAttempt) throws IOException {
            this.wrapper.executeExceptionableActionOnDTestClassLoader(() -> {
                super.connectInternal(currentAttempt);
                return null;
            });
        }
    }

    public static class IntegrationTestModule
    extends AbstractModule {
        private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestModule.class);
        private final Iterable<? extends IInstance> instances;
        private final IsolatedDTestClassLoaderWrapper wrapper;
        private final MtlsTestHelper mtlsTestHelper;
        private final DnsResolver dnsResolver;
        private final Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> configurationOverrides;

        public IntegrationTestModule(Iterable<? extends IInstance> instances, IsolatedDTestClassLoaderWrapper wrapper, MtlsTestHelper mtlsTestHelper, DnsResolver dnsResolver, Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> configurationOverrides) {
            this.instances = instances;
            this.wrapper = wrapper;
            this.mtlsTestHelper = mtlsTestHelper;
            this.configurationOverrides = configurationOverrides;
            this.dnsResolver = dnsResolver;
        }

        @Provides
        @Singleton
        public CQLSessionProvider cqlSessionProvider() {
            List<InetSocketAddress> contactPoints = this.buildContactPoints();
            return new TemporaryCqlSessionProvider(contactPoints, SharedExecutorNettyOptions.INSTANCE);
        }

        @Provides
        @Singleton
        public InstancesMetadata instancesConfig(Vertx vertx, SidecarConfiguration configuration, CassandraVersionProvider cassandraVersionProvider, SidecarVersionProvider sidecarVersionProvider, CQLSessionProvider cqlSessionProvider, DnsResolver dnsResolver) {
            JmxConfiguration jmxConfiguration = configuration.serviceConfiguration().jmxConfiguration();
            List instanceMetadataList = StreamSupport.stream(this.instances.spliterator(), false).map(instance -> IntegrationTestModule.buildInstanceMetadata(vertx, instance, cassandraVersionProvider, sidecarVersionProvider.sidecarVersion(), jmxConfiguration, cqlSessionProvider, dnsResolver, this.wrapper)).collect(Collectors.toList());
            return new InstancesMetadataImpl(instanceMetadataList, dnsResolver);
        }

        @Provides
        @Singleton
        public SidecarConfiguration sidecarConfiguration() {
            ClusterLeaseClaimConfigurationImpl clusterLeaseClaimConfiguration = ClusterLeaseClaimConfigurationImpl.builder().initialDelayRandomDelta(MillisecondBoundConfiguration.parse((String)"1s")).build();
            ServiceConfigurationImpl conf = ServiceConfigurationImpl.builder().host("0.0.0.0").port(0).schemaKeyspaceConfiguration((SchemaKeyspaceConfiguration)SchemaKeyspaceConfigurationImpl.builder().isEnabled(true).build()).sstableUploadConfiguration((SSTableUploadConfiguration)new SSTableUploadConfigurationImpl(80, 1.0f, "rw-r--r--")).coordinationConfiguration((CoordinationConfiguration)new CoordinationConfigurationImpl((ClusterLeaseClaimConfiguration)clusterLeaseClaimConfiguration)).build();
            SslConfigurationImpl sslConfiguration = null;
            if (this.mtlsTestHelper.isEnabled()) {
                LOGGER.info("Enabling test mTLS certificate/keystore.");
                KeyStoreConfigurationImpl truststoreConfiguration = new KeyStoreConfigurationImpl(this.mtlsTestHelper.trustStorePath(), this.mtlsTestHelper.trustStorePassword(), this.mtlsTestHelper.trustStoreType(), SecondBoundConfiguration.ZERO);
                KeyStoreConfigurationImpl keyStoreConfiguration = new KeyStoreConfigurationImpl(this.mtlsTestHelper.serverKeyStorePath(), this.mtlsTestHelper.serverKeyStorePassword(), this.mtlsTestHelper.serverKeyStoreType(), SecondBoundConfiguration.ZERO);
                sslConfiguration = SslConfigurationImpl.builder().enabled(true).keystore((KeyStoreConfiguration)keyStoreConfiguration).truststore((KeyStoreConfiguration)truststoreConfiguration).build();
            } else {
                LOGGER.info("Not enabling mTLS for testing purposes. Set '{}' to 'true' if you would like mTLS enabled.", (Object)"cassandra.integration.sidecar.test.enable_mtls");
            }
            S3ClientConfigurationImpl s3ClientConfig = new S3ClientConfigurationImpl("s3-client", 4, S3ClientConfigurationImpl.DEFAULT_THREAD_KEEP_ALIVE, 0x500000, S3ClientConfigurationImpl.DEFAULT_API_CALL_TIMEOUT, this.buildTestS3ProxyConfig());
            SidecarConfigurationImpl.Builder builder = SidecarConfigurationImpl.builder().serviceConfiguration((ServiceConfiguration)conf).sslConfiguration(sslConfiguration).s3ClientConfiguration((S3ClientConfiguration)s3ClientConfig);
            if (this.configurationOverrides != null) {
                builder = this.configurationOverrides.apply(builder);
            }
            return builder.build();
        }

        @Provides
        @Singleton
        public DnsResolver dnsResolver() {
            return this.dnsResolver;
        }

        private List<InetSocketAddress> buildContactPoints() {
            return StreamSupport.stream(this.instances.spliterator(), false).map(instance -> new InetSocketAddress(instance.config().broadcastAddress().getAddress(), IntegrationTestModule.tryGetIntConfig(instance.config(), "native_transport_port", 9042))).collect(Collectors.toList());
        }

        private S3ProxyConfiguration buildTestS3ProxyConfig() {
            return new S3ProxyConfiguration(){

                public URI proxy() {
                    return null;
                }

                public String username() {
                    return null;
                }

                public String password() {
                    return null;
                }

                public URI endpointOverride() {
                    return URI.create("http://localhost:9090");
                }
            };
        }

        static int tryGetIntConfig(IInstanceConfig config, String configName, int defaultValue) {
            try {
                return config.getInt(configName);
            }
            catch (NullPointerException npe) {
                return defaultValue;
            }
        }

        static InstanceMetadata buildInstanceMetadata(Vertx vertx, IInstance cassandraInstance, CassandraVersionProvider versionProvider, String sidecarVersion, JmxConfiguration jmxConfiguration, CQLSessionProvider session, DnsResolver dnsResolver, IsolatedDTestClassLoaderWrapper wrapper) {
            String hostName;
            IInstanceConfig config = cassandraInstance.config();
            String ipAddress = JMXUtil.getJmxHost((IInstanceConfig)config);
            try {
                hostName = dnsResolver.reverseResolve(ipAddress);
            }
            catch (UnknownHostException e) {
                hostName = ipAddress;
            }
            int port = IntegrationTestModule.tryGetIntConfig(config, "native_transport_port", 9042);
            String[] dataDirectories = (String[])config.get("data_file_directories");
            String stagingDir = IntegrationTestModule.stagingDir(dataDirectories);
            JmxClientProxy jmxClient = new JmxClientProxy(wrapper, JmxClient.builder().host(ipAddress).port(config.jmxPort()).connectionMaxRetries(jmxConfiguration.maxRetries()).connectionRetryDelay((DurationSpec)jmxConfiguration.retryDelay()));
            MetricRegistry metricRegistry = new MetricRegistry();
            CassandraAdapterDelegate delegate = new CassandraAdapterDelegate(vertx, config.num(), versionProvider, session, (JmxClient)jmxClient, new DriverUtils(), sidecarVersion, ipAddress, port, new InstanceHealthMetrics(metricRegistry));
            return InstanceMetadataImpl.builder().id(config.num()).host(hostName).port(port).dataDirs(Arrays.asList(dataDirectories)).cdcDir(config.getString("cdc_raw_directory")).commitlogDir(config.getString("commitlog_directory")).hintsDir(config.getString("hints_directory")).savedCachesDir(config.getString("saved_caches_directory")).stagingDir(stagingDir).delegate(delegate).metricRegistry(metricRegistry).build();
        }

        private static String stagingDir(String[] dataDirectories) {
            Path dataDirParentPath = Paths.get(dataDirectories[0], new String[0]).getParent();
            Assertions.assertThat((Path)dataDirParentPath).isNotNull();
            Path stagingPath = dataDirParentPath.resolve("staging");
            return stagingPath.toFile().getAbsolutePath();
        }
    }
}

