/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import org.apache.cassandra.sidecar.common.utils.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateSliceRequestPayload {
    private final String sliceId;
    private final int bucketId;
    private final String bucket;
    private final String key;
    private final String checksum;
    private final BigInteger firstToken;
    private final BigInteger endToken;
    private final Long uncompressedSize;
    private final Long compressedSize;

    @JsonCreator
    public CreateSliceRequestPayload(@JsonProperty(value="sliceId") String sliceId, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="storageBucket") String bucket, @JsonProperty(value="storageKey") String key, @JsonProperty(value="sliceChecksum") String checksum, @JsonProperty(value="startToken") BigInteger firstToken, @JsonProperty(value="endToken") BigInteger endToken, @JsonProperty(value="sliceUncompressedSize") Long uncompressedSize, @JsonProperty(value="sliceCompressedSize") Long compressedSize) {
        Preconditions.checkArgument(sliceId != null && checksum != null && bucket != null && key != null && firstToken != null && endToken != null, "Invalid create slice request payload");
        Preconditions.checkArgument(bucketId < Short.MAX_VALUE && bucketId >= 0, "Invalid bucketId. Valid range: [0, 32767), but got " + bucketId);
        this.sliceId = sliceId;
        this.bucketId = bucketId;
        this.bucket = bucket;
        this.key = key;
        this.checksum = checksum;
        this.firstToken = firstToken;
        this.endToken = endToken;
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
    }

    @JsonProperty(value="sliceId")
    public String sliceId() {
        return this.sliceId;
    }

    @JsonProperty(value="bucketId")
    public int bucketId() {
        return this.bucketId;
    }

    public short bucketIdAsShort() {
        return (short)this.bucketId;
    }

    @JsonProperty(value="storageBucket")
    public String bucket() {
        return this.bucket;
    }

    @JsonProperty(value="storageKey")
    public String key() {
        return this.key;
    }

    @JsonProperty(value="startToken")
    public BigInteger firstToken() {
        return this.firstToken;
    }

    @JsonProperty(value="endToken")
    public BigInteger endToken() {
        return this.endToken;
    }

    @JsonProperty(value="sliceChecksum")
    public String checksum() {
        return this.checksum;
    }

    @JsonProperty(value="sliceUncompressedSize")
    public Long uncompressedSize() {
        return this.uncompressedSize;
    }

    public long uncompressedSizeOrZero() {
        return this.uncompressedSize == null ? 0L : this.uncompressedSize;
    }

    @JsonProperty(value="sliceCompressedSize")
    public Long compressedSize() {
        return this.compressedSize;
    }

    public long compressedSizeOrZero() {
        return this.compressedSize == null ? 0L : this.compressedSize;
    }

    public String toString() {
        return "CreateSliceRequest{sliceId='" + this.sliceId + "', bucketId='" + this.bucketId + "', storageBucket='" + this.bucket + "', storageKey='" + this.key + "', sliceChecksum='" + this.checksum + "', startToken='" + String.valueOf(this.firstToken) + "', endToken='" + String.valueOf(this.endToken) + "', sliceCompressedSize='" + this.compressedSize + "', sliceUncompressedSize='" + this.uncompressedSize + "'}";
    }
}

