/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.common.response.data.CdcSegmentInfo;
import o.a.c.sidecar.client.shaded.common.utils.HttpRange;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.sidecar.SidecarCdcCommitLogSegment;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.exceptions.TransportFailureException;
import org.apache.cassandra.spark.utils.MapUtils;
import org.apache.cassandra.spark.utils.Properties;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.spark.utils.streaming.StreamBuffer;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.jetbrains.annotations.Nullable;

public class SidecarCdcClient {
    final ClientConfig config;
    final SidecarClient sidecarClient;
    final ICdcStats stats;

    public SidecarCdcClient(ClientConfig config, SidecarClient sidecarClient, ICdcStats stats) {
        this.config = config;
        this.sidecarClient = sidecarClient;
        this.stats = stats;
    }

    public CompletableFuture<List<CommitLog>> listCdcCommitLogSegments(CassandraInstance instance) {
        return ((CompletableFuture)this.sidecarClient.listCdcSegments(this.toSidecarInstance(instance)).thenApply(response -> response.segmentsInfo().stream().map(segment -> new SidecarCdcCommitLogSegment(this, instance, (CdcSegmentInfo)segment, this.config)).collect(Collectors.toList()))).exceptionally(throwable -> {
            Throwable cause = ThrowableUtils.rootCause((Throwable)throwable);
            if (cause instanceof TransportFailureException.Nonretryable && ((TransportFailureException.Nonretryable)cause).isNotFound()) {
                return Collections.emptyList();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(cause);
        });
    }

    public void streamCdcCommitLogSegment(CassandraInstance instance, String segment, HttpRange httpRange, final StreamConsumer streamConsumer) {
        this.sidecarClient.streamCdcSegments(this.toSidecarInstance(instance), segment, httpRange, new o.a.c.sidecar.client.shaded.client.StreamConsumer(){

            public void onRead(final o.a.c.sidecar.client.shaded.client.StreamBuffer streamBuffer) {
                streamConsumer.onRead(new StreamBuffer(){

                    public void getBytes(int index, ByteBuffer destination, int length) {
                        streamBuffer.copyBytes(index, destination, length);
                    }

                    public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
                        streamBuffer.copyBytes(index, destination, destinationIndex, length);
                    }

                    public byte getByte(int index) {
                        return streamBuffer.getByte(index);
                    }

                    public int readableBytes() {
                        return streamBuffer.readableBytes();
                    }

                    public void release() {
                        streamBuffer.release();
                    }
                });
            }

            public void onComplete() {
                streamConsumer.onEnd();
            }

            public void onError(Throwable throwable) {
                streamConsumer.onError(throwable);
            }
        });
    }

    protected SidecarInstance toSidecarInstance(final CassandraInstance instance) {
        return new SidecarInstance(){

            public int port() {
                return SidecarCdcClient.this.config.effectivePort();
            }

            public String hostname() {
                return instance.nodeName();
            }
        };
    }

    public static final class ClientConfig {
        public static final String MAX_BUFFER_SIZE_BYTES_KEY = "maxBufferSizeBytes";
        public static final String CHUNK_BUFFER_SIZE_BYTES_KEY = "chunkBufferSizeBytes";
        public static final String DEFAULT_CASSANDRA_ROLE = null;
        private final int userProvidedPort;
        private final int maxRetries;
        private final int maxPoolSize;
        private final int timeoutSeconds;
        private final long millisToSleep;
        private final long maxMillisToSleep;
        private final long maxBufferSize;
        private final long chunkSize;
        private final String cassandraRole;
        private final Map<FileType, Long> maxBufferOverride;
        private final Map<FileType, Long> chunkBufferOverride;

        private ClientConfig(int userProvidedPort, int maxRetries, long millisToSleep, long maxMillisToSleep, long maxBufferSize, long chunkSize, int maxPoolSize, int timeoutSeconds, String cassandraRole, Map<FileType, Long> maxBufferOverride, Map<FileType, Long> chunkBufferOverride) {
            this.userProvidedPort = userProvidedPort;
            this.maxRetries = maxRetries;
            this.millisToSleep = millisToSleep;
            this.maxMillisToSleep = maxMillisToSleep;
            this.maxBufferSize = maxBufferSize;
            this.chunkSize = chunkSize;
            this.maxPoolSize = maxPoolSize;
            this.timeoutSeconds = timeoutSeconds;
            this.cassandraRole = cassandraRole;
            this.maxBufferOverride = maxBufferOverride;
            this.chunkBufferOverride = chunkBufferOverride;
        }

        public int userProvidedPort() {
            return this.userProvidedPort;
        }

        public int effectivePort() {
            return this.userProvidedPort == -1 ? 9043 : this.userProvidedPort;
        }

        public int maxRetries() {
            return this.maxRetries;
        }

        public long millisToSleep() {
            return this.millisToSleep;
        }

        public long maxMillisToSleep() {
            return this.maxMillisToSleep;
        }

        public long maxBufferSize() {
            return this.maxBufferSize(FileType.COMMITLOG);
        }

        public long maxBufferSize(FileType fileType) {
            return this.maxBufferOverride.getOrDefault(fileType, this.maxBufferSize);
        }

        public Map<FileType, Long> maxBufferOverride() {
            return this.maxBufferOverride;
        }

        public long chunkBufferSize() {
            return this.chunkBufferSize(FileType.COMMITLOG);
        }

        public long chunkBufferSize(FileType fileType) {
            return this.chunkBufferOverride.getOrDefault(fileType, this.chunkSize);
        }

        public Map<FileType, Long> chunkBufferOverride() {
            return this.chunkBufferOverride;
        }

        public int maxPoolSize() {
            return this.maxPoolSize;
        }

        public int timeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Nullable
        public String cassandraRole() {
            return this.cassandraRole;
        }

        public static ClientConfig create() {
            return ClientConfig.create(-1, 10, 500L);
        }

        public static ClientConfig create(int userProvidedPort, int effectivePort) {
            return ClientConfig.create(userProvidedPort, 10, 500L);
        }

        public static ClientConfig create(int userProvidedPort, int maxRetries, long millisToSleep) {
            HashMap<FileType, Long> chunkOverride = new HashMap<FileType, Long>();
            chunkOverride.put(FileType.COMMITLOG, 0x400000L);
            return ClientConfig.create(userProvidedPort, maxRetries, millisToSleep, Properties.DEFAULT_MAX_MILLIS_TO_SLEEP, 0x600000L, 0x400000L, 64, Properties.DEFAULT_TIMEOUT_SECONDS, DEFAULT_CASSANDRA_ROLE, Properties.DEFAULT_MAX_BUFFER_OVERRIDE, chunkOverride);
        }

        public static Map<FileType, Long> buildMaxBufferOverride(Map<String, String> options, Map<FileType, Long> defaultValue) {
            return ClientConfig.buildOverrideMap(MAX_BUFFER_SIZE_BYTES_KEY, options, defaultValue);
        }

        public static Map<FileType, Long> buildChunkBufferOverride(Map<String, String> options, Map<FileType, Long> defaultValue) {
            return ClientConfig.buildOverrideMap(CHUNK_BUFFER_SIZE_BYTES_KEY, options, defaultValue);
        }

        private static Map<FileType, Long> buildOverrideMap(String keyPrefix, Map<String, String> options, Map<FileType, Long> defaultValue) {
            HashMap<FileType, Long> result = new HashMap<FileType, Long>(defaultValue);
            for (FileType type : FileType.values()) {
                String key = MapUtils.lowerCaseKey((String)String.format("%s_%s", keyPrefix, type.getFileSuffix()));
                Optional.ofNullable(options.get(key)).map(Long::parseLong).ifPresent(s -> result.put(type, (Long)s));
            }
            return result;
        }

        public static ClientConfig create(int userProvidedPort, int maxRetries, long millisToSleep, long maxMillisToSleep, long maxBufferSizeBytes, long chunkSizeBytes, int maxPoolSize, int timeoutSeconds, String cassandraRole, Map<FileType, Long> maxBufferOverride, Map<FileType, Long> chunkBufferOverride) {
            return new ClientConfig(userProvidedPort, maxRetries, millisToSleep, maxMillisToSleep, maxBufferSizeBytes, chunkSizeBytes, maxPoolSize, timeoutSeconds, cassandraRole, maxBufferOverride, chunkBufferOverride);
        }

        public Sidecar.ClientConfig toGenericSidecarConfig() {
            return Sidecar.ClientConfig.create((int)this.userProvidedPort, (int)this.maxRetries, (long)this.millisToSleep, (long)this.maxMillisToSleep, (long)0x600000L, (long)0x400000L, (int)this.maxPoolSize, (int)this.timeoutSeconds, (String)this.cassandraRole, this.maxBufferOverride, this.chunkBufferOverride);
        }
    }
}

