/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.reader.common.RawInputStream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.UnfilteredDeserializer;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.SSTableSimpleIterator;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.CompressedRawInputStream;
import org.apache.cassandra.spark.reader.CompressionMetadata;
import org.apache.cassandra.spark.reader.IndexDbUtils;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.SSTableCache;
import org.apache.cassandra.spark.reader.Scannable;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.apache.cassandra.spark.reader.SummaryDbUtils;
import org.apache.cassandra.spark.reader.common.SSTableStreamException;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableReader
implements SparkSSTableReader,
Scannable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSTableReader.class);
    private final TableMetadata metadata;
    @NotNull
    private final SSTable ssTable;
    private final StatsMetadata statsMetadata;
    @NotNull
    private final Version version;
    @NotNull
    private final DecoratedKey first;
    @NotNull
    private final DecoratedKey last;
    @NotNull
    private final BigInteger firstToken;
    @NotNull
    private final BigInteger lastToken;
    private final SerializationHeader header;
    private final DeserializationHelper helper;
    @NotNull
    private final AtomicReference<SSTableStreamReader> reader = new AtomicReference<Object>(null);
    @Nullable
    private final SparkRangeFilter sparkRangeFilter;
    @NotNull
    private final List<PartitionKeyFilter> partitionKeyFilters;
    @NotNull
    private final Stats stats;
    @Nullable
    private Long startOffset = null;
    private Long openedNanos = null;
    @NotNull
    private final Function<StatsMetadata, Boolean> isRepaired;

    public static Builder builder(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) {
        return new Builder(metadata, ssTable);
    }

    public SSTableReader(@NotNull TableMetadata metadata, @NotNull SSTable ssTable, @Nullable SparkRangeFilter sparkRangeFilter, @NotNull List<PartitionKeyFilter> partitionKeyFilters, @Nullable PruneColumnFilter columnFilter, boolean readIndexOffset, @NotNull Stats stats, boolean useIncrementalRepair, boolean isRepairPrimary, @NotNull Function<StatsMetadata, Boolean> isRepaired) throws IOException {
        Map<MetadataType, MetadataComponent> componentMap;
        ValidationMetadata validation;
        boolean overlapsSparkRange;
        long now;
        long startTimeNanos = System.nanoTime();
        this.ssTable = ssTable;
        this.stats = stats;
        this.isRepaired = isRepaired;
        this.sparkRangeFilter = sparkRangeFilter;
        Descriptor descriptor = ReaderUtils.constructDescriptor(metadata.keyspace, metadata.name, ssTable);
        this.version = descriptor.version;
        SummaryDbUtils.Summary summary = null;
        Pair<DecoratedKey, DecoratedKey> keys = null;
        try {
            now = System.nanoTime();
            summary = SSTableCache.INSTANCE.keysFromSummary(metadata, ssTable);
            stats.readSummaryDb(ssTable, System.nanoTime() - now);
            keys = Pair.of((Object)summary.first(), (Object)summary.last());
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to read Summary.db file ssTable='{}'", (Object)ssTable, (Object)exception);
        }
        if (keys == null) {
            if (ssTable.isBigFormat()) {
                LOGGER.warn("Could not load first and last key from Summary.db file, so attempting Index.db fileName={}", (Object)ssTable.getDataFileName());
            }
            now = System.nanoTime();
            keys = SSTableCache.INSTANCE.keysFromIndex(metadata, ssTable);
            stats.readIndexDb(ssTable, System.nanoTime() - now);
        }
        if (keys == null) {
            throw new IOException("Could not load SSTable first or last tokens");
        }
        this.first = (DecoratedKey)keys.left;
        this.last = (DecoratedKey)keys.right;
        this.firstToken = ReaderUtils.tokenToBigInteger((Token)this.first.getToken());
        this.lastToken = ReaderUtils.tokenToBigInteger((Token)this.last.getToken());
        TokenRange readerRange = this.range();
        List<PartitionKeyFilter> matchingKeyFilters = partitionKeyFilters.stream().filter(filter -> readerRange.contains(filter.token())).collect(Collectors.toList());
        boolean bl = overlapsSparkRange = sparkRangeFilter == null || SparkSSTableReader.overlaps((SparkSSTableReader)this, (TokenRange)sparkRangeFilter.tokenRange());
        if (!overlapsSparkRange || matchingKeyFilters.isEmpty() && !partitionKeyFilters.isEmpty()) {
            this.partitionKeyFilters = Collections.emptyList();
            stats.skippedSSTable(sparkRangeFilter, partitionKeyFilters, this.firstToken, this.lastToken);
            LOGGER.info("Ignoring SSTableReader with firstToken={} lastToken={}, does not overlap with any filter", (Object)this.firstToken, (Object)this.lastToken);
            this.statsMetadata = null;
            this.header = null;
            this.helper = null;
            this.metadata = null;
            return;
        }
        if (!matchingKeyFilters.isEmpty()) {
            List<PartitionKeyFilter> matchInBloomFilter = ReaderUtils.filterKeyInBloomFilter(ssTable, metadata.partitioner, descriptor, matchingKeyFilters);
            this.partitionKeyFilters = ImmutableList.copyOf(matchInBloomFilter);
            if (matchInBloomFilter.isEmpty() || !ReaderUtils.anyFilterKeyInIndex(ssTable, matchInBloomFilter)) {
                if (matchInBloomFilter.isEmpty()) {
                    stats.missingInBloomFilter();
                } else {
                    stats.missingInIndex();
                }
                LOGGER.info("Ignoring SSTable {}, no match found in index file for key filters", (Object)this.ssTable.getDataFileName());
                this.statsMetadata = null;
                this.header = null;
                this.helper = null;
                this.metadata = null;
                return;
            }
        } else {
            this.partitionKeyFilters = ImmutableList.copyOf(partitionKeyFilters);
        }
        if ((validation = (ValidationMetadata)(componentMap = SSTableCache.INSTANCE.componentMapFromStats(ssTable, descriptor)).get(MetadataType.VALIDATION)) != null && !validation.partitioner.equals(metadata.partitioner.getClass().getName())) {
            throw new IllegalStateException("Partitioner in ValidationMetadata does not match TableMetaData: " + validation.partitioner + " vs. " + metadata.partitioner.getClass().getName());
        }
        this.statsMetadata = (StatsMetadata)componentMap.get(MetadataType.STATS);
        SerializationHeader.Component headerComp = (SerializationHeader.Component)componentMap.get(MetadataType.HEADER);
        if (headerComp == null) {
            throw new IOException("Cannot read SSTable if cannot deserialize stats header info");
        }
        if (useIncrementalRepair && !isRepairPrimary && this.isRepaired()) {
            stats.skippedRepairedSSTable(ssTable, this.statsMetadata.repairedAt);
            LOGGER.info("Ignoring repaired SSTable on non-primary repair replica ssTable='{}' repairedAt={}", (Object)ssTable, (Object)this.statsMetadata.repairedAt);
            this.header = null;
            this.helper = null;
            this.metadata = null;
            return;
        }
        Set<String> columnNames = Streams.concat((Stream[])new Stream[]{metadata.columns().stream(), metadata.staticColumns().stream()}).map(column -> column.name.toString()).collect(Collectors.toSet());
        HashMap<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
        droppedColumns.putAll(SSTableReader.buildDroppedColumns(metadata.keyspace, metadata.name, ssTable, headerComp.getRegularColumns(), columnNames, ColumnMetadata.Kind.REGULAR));
        droppedColumns.putAll(SSTableReader.buildDroppedColumns(metadata.keyspace, metadata.name, ssTable, headerComp.getStaticColumns(), columnNames, ColumnMetadata.Kind.STATIC));
        if (!droppedColumns.isEmpty()) {
            LOGGER.info("Rebuilding table metadata with dropped columns numDroppedColumns={} ssTable='{}'", (Object)droppedColumns.size(), (Object)ssTable);
            metadata = metadata.unbuild().droppedColumns(droppedColumns).build();
        }
        this.header = headerComp.toHeader(metadata);
        this.helper = new DeserializationHelper(metadata, 10, DeserializationHelper.Flag.FROM_REMOTE, SSTableReader.buildColumnFilter(metadata, columnFilter));
        this.metadata = metadata;
        if (readIndexOffset && summary != null) {
            SummaryDbUtils.Summary finalSummary = summary;
            SSTableReader.extractRange(sparkRangeFilter, partitionKeyFilters).ifPresent(range -> this.readOffsets(finalSummary.summary(), (TokenRange)range));
        } else {
            LOGGER.warn("Reading SSTable without looking up start/end offset, performance will potentially be degraded");
        }
        this.reader.set(new SSTableStreamReader());
        stats.openedSSTable(ssTable, System.nanoTime() - startTimeNanos);
        this.openedNanos = System.nanoTime();
    }

    private static Map<ByteBuffer, DroppedColumn> buildDroppedColumns(String keyspace, String table, SSTable ssTable, Map<ByteBuffer, AbstractType<?>> columns, Set<String> columnNames, ColumnMetadata.Kind kind) {
        HashMap<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
        for (Map.Entry<ByteBuffer, AbstractType<?>> entry : columns.entrySet()) {
            String colName = UTF8Type.instance.getString(entry.getKey());
            if (columnNames.contains(colName)) continue;
            AbstractType<?> type = entry.getValue();
            LOGGER.warn("Dropped column found colName={} sstable='{}'", (Object)colName, (Object)ssTable);
            ColumnMetadata column = new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned((String)colName, (boolean)true), type, -1, kind);
            long droppedTime = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) - TimeUnit.MINUTES.toMicros(60L);
            droppedColumns.put(entry.getKey(), new DroppedColumn(column, droppedTime));
        }
        return droppedColumns;
    }

    public static Optional<TokenRange> extractRange(@Nullable SparkRangeFilter sparkRangeFilter, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        Optional<TokenRange> partitionKeyRange = partitionKeyFilters.stream().map(PartitionKeyFilter::tokenRange).reduce(TokenRange::merge);
        return partitionKeyRange.isPresent() ? partitionKeyRange : Optional.ofNullable(sparkRangeFilter != null ? sparkRangeFilter.tokenRange() : null);
    }

    private void readOffsets(IndexSummary indexSummary, TokenRange range) {
        try {
            this.startOffset = IndexDbUtils.findDataDbOffset(indexSummary, range, this.metadata.partitioner, this.ssTable, this.stats);
            if (this.startOffset == null) {
                LOGGER.error("Failed to find Data.db start offset, performance will be degraded sstable='{}'", (Object)this.ssTable);
            }
        }
        catch (IOException exception) {
            LOGGER.warn("IOException finding SSTable offsets, cannot skip directly to start offset in Data.db. Performance will be degraded.", (Throwable)exception);
        }
    }

    @Nullable
    private static ColumnFilter buildColumnFilter(TableMetadata metadata, @Nullable PruneColumnFilter columnFilter) {
        if (columnFilter == null) {
            return null;
        }
        List include = metadata.columns().stream().filter(column -> columnFilter.includeColumn(column.name.toString())).collect(Collectors.toList());
        if (include.size() == metadata.columns().size()) {
            return null;
        }
        return ColumnFilter.allRegularColumnsBuilder((TableMetadata)metadata, (boolean)false).addAll(include).build();
    }

    public SSTable sstable() {
        return this.ssTable;
    }

    public boolean ignore() {
        return this.reader.get() == null;
    }

    public int hashCode() {
        return Objects.hash(this.metadata.keyspace, this.metadata.name, this.ssTable);
    }

    public boolean equals(Object other) {
        return other instanceof SSTableReader && this.metadata.keyspace.equals(((SSTableReader)other).metadata.keyspace) && this.metadata.name.equals(((SSTableReader)other).metadata.name) && this.ssTable.equals(((SSTableReader)other).ssTable);
    }

    public boolean isRepaired() {
        return this.isRepaired.apply(this.statsMetadata);
    }

    public DecoratedKey first() {
        return this.first;
    }

    public DecoratedKey last() {
        return this.last;
    }

    public long getMinTimestamp() {
        return this.statsMetadata.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.statsMetadata.maxTimestamp;
    }

    public StatsMetadata getSSTableMetadata() {
        return this.statsMetadata;
    }

    @Override
    public ISSTableScanner scanner() {
        ISSTableScanner result = this.reader.getAndSet(null);
        if (result == null) {
            throw new IllegalStateException("SSTableStreamReader cannot be re-used");
        }
        return result;
    }

    @NotNull
    public BigInteger firstToken() {
        return this.firstToken;
    }

    @NotNull
    public BigInteger lastToken() {
        return this.lastToken;
    }

    public class SSTableStreamReader
    implements ISSTableScanner {
        private final DataInputStream dis;
        private final DataInputPlus in;
        final RawInputStream dataStream;
        private DecoratedKey key;
        private DeletionTime partitionLevelDeletion;
        private SSTableSimpleIterator iterator;
        private Row staticRow;
        @Nullable
        private final BigInteger lastToken;
        private long lastTimeNanos = System.nanoTime();

        SSTableStreamReader() throws IOException {
            this.lastToken = SSTableReader.this.sparkRangeFilter != null ? SSTableReader.this.sparkRangeFilter.tokenRange().upperEndpoint() : null;
            CompressionMetadata compressionMetadata = SSTableCache.INSTANCE.compressionMetadata(SSTableReader.this.ssTable, SSTableReader.this.version.hasMaxCompressedLength(), SSTableReader.this.metadata.params.crcCheckChance);
            DataInputStream dataInputStream = new DataInputStream(SSTableReader.this.ssTable.openDataStream());
            this.dataStream = compressionMetadata != null ? CompressedRawInputStream.from(SSTableReader.this.ssTable, dataInputStream, compressionMetadata, SSTableReader.this.stats) : new RawInputStream(dataInputStream, new byte[65536], SSTableReader.this.stats);
            this.dis = new DataInputStream((InputStream)this.dataStream);
            if (SSTableReader.this.startOffset != null) {
                ByteBufferUtils.skipFully((InputStream)this.dis, (long)SSTableReader.this.startOffset);
                assert (this.dataStream.position() == SSTableReader.this.startOffset.longValue());
                LOGGER.info("Using Data.db start offset to skip ahead startOffset={} sstable='{}'", (Object)SSTableReader.this.startOffset, (Object)SSTableReader.this.ssTable);
                SSTableReader.this.stats.skippedDataDbStartOffset(SSTableReader.this.startOffset.longValue());
            }
            this.in = new DataInputPlus.DataInputStreamPlus((InputStream)this.dis);
        }

        public TableMetadata metadata() {
            return SSTableReader.this.metadata;
        }

        public boolean overlapsSparkTokenRange(BigInteger token) {
            return SSTableReader.this.sparkRangeFilter == null || SSTableReader.this.sparkRangeFilter.overlaps(token);
        }

        public boolean overlapsPartitionFilters(DecoratedKey key) {
            return SSTableReader.this.partitionKeyFilters.isEmpty() || SSTableReader.this.partitionKeyFilters.stream().anyMatch(filter -> filter.matches(key.getKey()));
        }

        public boolean overlaps(DecoratedKey key, BigInteger token) {
            return this.overlapsSparkTokenRange(token) && this.overlapsPartitionFilters(key);
        }

        public boolean hasNext() {
            try {
                block4: while (true) {
                    this.key = SSTableReader.this.metadata.partitioner.decorateKey(ByteBufferUtil.readWithShortLength((DataInput)this.in));
                    this.partitionLevelDeletion = DeletionTime.serializer.deserialize(this.in);
                    this.iterator = SSTableSimpleIterator.create((TableMetadata)SSTableReader.this.metadata, (DataInputPlus)this.in, (SerializationHeader)SSTableReader.this.header, (DeserializationHelper)SSTableReader.this.helper, (DeletionTime)this.partitionLevelDeletion);
                    this.staticRow = this.iterator.readStaticRow();
                    BigInteger token = ReaderUtils.tokenToBigInteger((Token)this.key.getToken());
                    if (this.overlaps(this.key, token)) {
                        long now = System.nanoTime();
                        SSTableReader.this.stats.nextPartition(now - this.lastTimeNanos);
                        this.lastTimeNanos = now;
                        return true;
                    }
                    if (this.lastToken != null && SSTableReader.this.startOffset != null && this.lastToken.compareTo(token) < 0) {
                        SSTableReader.this.stats.skippedDataDbEndOffset(this.dataStream.position() - SSTableReader.this.startOffset);
                        return false;
                    }
                    SSTableReader.this.stats.skippedPartition(this.key.getKey(), ReaderUtils.tokenToBigInteger((Token)this.key.getToken()));
                    UnfilteredDeserializer deserializer = UnfilteredDeserializer.create((TableMetadata)SSTableReader.this.metadata, (DataInputPlus)this.in, (SerializationHeader)SSTableReader.this.header, (DeserializationHelper)SSTableReader.this.helper);
                    while (true) {
                        if (!deserializer.hasNext()) continue block4;
                        deserializer.skipNext();
                    }
                    break;
                }
            }
            catch (EOFException exception) {
                return false;
            }
            catch (IOException exception) {
                SSTableReader.this.stats.corruptSSTable((Throwable)exception, SSTableReader.this.metadata.keyspace, SSTableReader.this.metadata.name, SSTableReader.this.ssTable);
                LOGGER.warn("IOException reading sstable keyspace={} table={} dataFileName={} ssTable='{}'", new Object[]{SSTableReader.this.metadata.keyspace, SSTableReader.this.metadata.name, SSTableReader.this.ssTable.getDataFileName(), SSTableReader.this.ssTable, exception});
                throw new SSTableStreamException(exception);
            }
            catch (Throwable throwable) {
                SSTableReader.this.stats.corruptSSTable(throwable, SSTableReader.this.metadata.keyspace, SSTableReader.this.metadata.name, SSTableReader.this.ssTable);
                LOGGER.error("Error reading sstable keyspace={} table={}  dataFileName={} ssTable='{}'", new Object[]{SSTableReader.this.metadata.keyspace, SSTableReader.this.metadata.name, SSTableReader.this.ssTable.getDataFileName(), SSTableReader.this.ssTable, throwable});
                throw new RuntimeException(ThrowableUtils.rootCause((Throwable)throwable));
            }
        }

        public UnfilteredRowIterator next() {
            return new UnfilteredIterator();
        }

        public void close() {
            LOGGER.debug("Closing SparkSSTableReader {}", (Object)SSTableReader.this.ssTable);
            try {
                this.dis.close();
                if (SSTableReader.this.openedNanos != null) {
                    SSTableReader.this.stats.closedSSTable(System.nanoTime() - SSTableReader.this.openedNanos);
                }
            }
            catch (IOException exception) {
                LOGGER.warn("IOException closing SSTable DataInputStream", (Throwable)exception);
            }
        }

        public long getLengthInBytes() {
            return 0L;
        }

        public long getCompressedLengthInBytes() {
            return 0L;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getBytesScanned() {
            return 0L;
        }

        public Set<org.apache.cassandra.io.sstable.format.SSTableReader> getBackingSSTables() {
            return Collections.emptySet();
        }

        private class UnfilteredIterator
        implements UnfilteredRowIterator {
            private UnfilteredIterator() {
            }

            public RegularAndStaticColumns columns() {
                return SSTableReader.this.metadata.regularAndStaticColumns();
            }

            public TableMetadata metadata() {
                return SSTableReader.this.metadata;
            }

            public boolean isReverseOrder() {
                return false;
            }

            public DecoratedKey partitionKey() {
                return SSTableStreamReader.this.key;
            }

            public DeletionTime partitionLevelDeletion() {
                return SSTableStreamReader.this.partitionLevelDeletion;
            }

            public Row staticRow() {
                return SSTableStreamReader.this.staticRow;
            }

            public EncodingStats stats() {
                return SSTableReader.this.header.stats();
            }

            public boolean hasNext() {
                try {
                    return SSTableStreamReader.this.iterator.hasNext();
                }
                catch (IOError error) {
                    if (error.getCause() instanceof IOException) {
                        throw new SSTableStreamException((IOException)error.getCause());
                    }
                    throw error;
                }
            }

            public Unfiltered next() {
                return (Unfiltered)SSTableStreamReader.this.iterator.next();
            }

            public void close() {
            }
        }
    }

    public static class Builder {
        @NotNull
        final TableMetadata metadata;
        @NotNull
        final SSTable ssTable;
        @Nullable
        PruneColumnFilter columnFilter = null;
        boolean readIndexOffset = true;
        @NotNull
        Stats stats = Stats.DoNothingStats.INSTANCE;
        boolean useIncrementalRepair = true;
        boolean isRepairPrimary = false;
        Function<StatsMetadata, Boolean> isRepaired = stats -> stats.repairedAt != 0L;
        @Nullable
        SparkRangeFilter sparkRangeFilter = null;
        @NotNull
        final List<PartitionKeyFilter> partitionKeyFilters = new ArrayList<PartitionKeyFilter>();

        Builder(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) {
            this.metadata = metadata;
            this.ssTable = ssTable;
        }

        public Builder withSparkRangeFilter(@Nullable SparkRangeFilter sparkRangeFilter) {
            this.sparkRangeFilter = sparkRangeFilter;
            return this;
        }

        public Builder withPartitionKeyFilters(@Nullable Collection<PartitionKeyFilter> partitionKeyFilters) {
            if (partitionKeyFilters != null) {
                this.partitionKeyFilters.addAll(partitionKeyFilters);
            }
            return this;
        }

        public Builder withPartitionKeyFilter(@NotNull PartitionKeyFilter partitionKeyFilter) {
            this.partitionKeyFilters.add(partitionKeyFilter);
            return this;
        }

        public Builder withColumnFilter(@Nullable PruneColumnFilter columnFilter) {
            this.columnFilter = columnFilter;
            return this;
        }

        public Builder withReadIndexOffset(boolean readIndexOffset) {
            this.readIndexOffset = readIndexOffset;
            return this;
        }

        public Builder withStats(@NotNull Stats stats) {
            this.stats = stats;
            return this;
        }

        public Builder useIncrementalRepair(boolean useIncrementalRepair) {
            this.useIncrementalRepair = useIncrementalRepair;
            return this;
        }

        public Builder isRepairPrimary(boolean isRepairPrimary) {
            this.isRepairPrimary = isRepairPrimary;
            return this;
        }

        public Builder withIsRepairedFunction(Function<StatsMetadata, Boolean> isRepaired) {
            this.isRepaired = isRepaired;
            return this;
        }

        public SSTableReader build() throws IOException {
            return new SSTableReader(this.metadata, this.ssTable, this.sparkRangeFilter, this.partitionKeyFilters, this.columnFilter, this.readIndexOffset, this.stats, this.useIncrementalRepair, this.isRepairPrimary, this.isRepaired);
        }
    }
}

