/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cdc.msg.RangeTombstoneBuilder;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class FourZeroRangeTombstoneBuilder
extends RangeTombstoneBuilder<RangeTombstoneMarker> {
    private final TableMetadata tableMetadata;
    private RangeTombstoneMarker rangeTombstoneMarker;

    public FourZeroRangeTombstoneBuilder(TableMetadata tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    public boolean hasIncompleteRange() {
        return this.rangeTombstoneMarker != null;
    }

    public void add(RangeTombstoneMarker marker) {
        if (this.expectOpen) {
            Preconditions.checkArgument((!marker.isBoundary() && marker.isOpen(false) ? 1 : 0) != 0, (Object)"Expect onyly open bound");
            this.rangeTombstoneMarker = marker;
            this.expectOpen = false;
        } else {
            Preconditions.checkArgument((boolean)marker.isClose(false), (Object)"Expect close bound or boundary");
            RangeTombstoneMarker lastMarker = this.rangeTombstoneMarker;
            ClusteringBound open = lastMarker.openBound(false);
            List<Value> start = this.buildClusteringKey((ClusteringPrefix<?>)open);
            ClusteringBound close = marker.closeBound(false);
            List<Value> end = this.buildClusteringKey((ClusteringPrefix<?>)close);
            this.rangeTombstone = this.buildTombstone(start, open.isInclusive(), end, close.isInclusive());
            if (marker.isBoundary()) {
                this.rangeTombstoneMarker = marker;
            } else {
                this.expectOpen = true;
                this.rangeTombstoneMarker = null;
            }
        }
    }

    private List<Value> buildClusteringKey(ClusteringPrefix<?> clustering) {
        ImmutableList ckMetadata = this.tableMetadata.clusteringColumns();
        ArrayList<Value> result = new ArrayList<Value>(clustering.size());
        for (int i = 0; i < ckMetadata.size() && i < clustering.size(); ++i) {
            result.add(this.buildValue(((ColumnMetadata)ckMetadata.get((int)i)).ksName, ((ColumnMetadata)ckMetadata.get((int)i)).name.toCQLString(), ((ColumnMetadata)ckMetadata.get((int)i)).type.asCQL3Type().toString(), clustering.bufferAt(i)));
        }
        return result;
    }
}

