/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.cassandra.cdc.FourZeroMutation;
import org.apache.cassandra.cdc.api.CommitLogInstance;
import org.apache.cassandra.cdc.api.Mutation;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.spark.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourZeroCommitLog
implements CommitLogInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(FourZeroCommitLog.class);
    private final Path directory;

    public FourZeroCommitLog(Path folder) {
        this.directory = folder;
        this.start();
    }

    public synchronized void start() {
        LOGGER.info("Starting CommitLog.");
        CommitLog.instance.start();
    }

    public synchronized void stop() {
        try {
            LOGGER.info("Shutting down CommitLog.");
            CommitLog.instance.stopUnsafe(true);
            CommitLog.instance.shutdownBlocking();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public synchronized void clear() {
        IOUtils.clearDirectory((Path)this.directory, path -> LOGGER.info("Deleting CommitLog: " + path.toString()));
    }

    public void add(Mutation mutation) {
        if (mutation instanceof FourZeroMutation) {
            this.add(((FourZeroMutation)mutation).mutation);
        }
    }

    public void add(org.apache.cassandra.db.Mutation mutation) {
        CommitLog.instance.add(mutation);
    }

    public void sync() {
        try {
            CommitLog.instance.sync(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

