/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.CellIterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.jetbrains.annotations.NotNull;

public class PartitionSizeIterator
implements PartitionReader<InternalRow> {
    private final StreamScanner<IndexEntry> it;
    private final CqlTable cqlTable;
    private final int numPartitionKeys;
    private final Stats stats;
    private final long startTimeNanos;
    private GenericInternalRow curr = null;
    private final SparkSqlTypeConverter sparkSqlTypeConverter;

    public PartitionSizeIterator(int partitionId, @NotNull DataLayer dataLayer) {
        this.cqlTable = dataLayer.cqlTable();
        this.numPartitionKeys = this.cqlTable.numPartitionKeys();
        this.stats = dataLayer.stats();
        this.startTimeNanos = System.nanoTime();
        this.it = dataLayer.openPartitionSizeIterator(partitionId);
        this.stats.openedPartitionSizeIterator(System.nanoTime() - this.startTimeNanos);
        this.sparkSqlTypeConverter = dataLayer.typeConverter();
    }

    public boolean next() throws IOException {
        if (this.it.next()) {
            this.it.advanceToNextColumn();
            IndexEntry entry = (IndexEntry)this.it.data();
            Object[] values = new Object[this.numPartitionKeys + 2];
            CellIterator.readPartitionKey((TypeConverter)this.sparkSqlTypeConverter, (ByteBuffer)entry.getPartitionKey(), (CqlTable)this.cqlTable, (Object[])values, (Stats)this.stats);
            values[this.numPartitionKeys] = entry.getUncompressed();
            values[this.numPartitionKeys + 1] = entry.getCompressed();
            this.curr = new GenericInternalRow(values);
            this.stats.emitIndexEntry(entry);
            return true;
        }
        return false;
    }

    public InternalRow get() {
        return this.curr;
    }

    public void close() throws IOException {
        this.it.close();
        this.stats.closedPartitionSizeIterator(System.nanoTime() - this.startTimeNanos);
    }
}

