/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContextFactory;
import org.apache.cassandra.spark.bulkwriter.CassandraBulkSourceRelation;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.exception.UnsupportedAnalyticsOperationException;
import org.apache.cassandra.spark.utils.ScalaConversionUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.jetbrains.annotations.NotNull;
import scala.collection.immutable.Map;

public class CassandraDataSink
implements DataSourceRegister,
CreatableRelationProvider {
    public CassandraDataSink() {
        CassandraBridgeFactory.validateBridges((CassandraVersion[])CassandraVersion.implementedVersions());
    }

    @NotNull
    public String shortName() {
        return "cassandraBulkWrite";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BaseRelation createRelation(@NotNull SQLContext sqlContext, @NotNull SaveMode saveMode, @NotNull Map<String, String> parameters, @NotNull Dataset<Row> data) {
        switch (saveMode) {
            case Append: {
                BulkWriterContext writerContext = null;
                try {
                    writerContext = this.factory().createBulkWriterContext(sqlContext.sparkContext(), ScalaConversionUtils.mapAsJavaMap(parameters), data.schema());
                    JobInfo jobInfo = writerContext.job();
                    CassandraBulkSourceRelation relation = new CassandraBulkSourceRelation(writerContext, sqlContext);
                    String description = "Cassandra bulk write for table " + String.valueOf(jobInfo.qualifiedTableName());
                    sqlContext.sparkContext().setJobGroup(jobInfo.getId(), description, false);
                    relation.insert(data, false);
                    CassandraBulkSourceRelation cassandraBulkSourceRelation = relation;
                    return cassandraBulkSourceRelation;
                }
                finally {
                    if (writerContext != null) {
                        writerContext.shutdown();
                    }
                    sqlContext.sparkContext().clearJobGroup();
                }
            }
            case Overwrite: {
                throw new UnsupportedAnalyticsOperationException("SaveMode.Overwrite is not supported on Cassandra as it needs privileged TRUNCATE operation");
            }
        }
        throw new UnsupportedAnalyticsOperationException("SaveMode." + String.valueOf(saveMode) + " is not supported");
    }

    @NotNull
    protected BulkWriterContextFactory factory() {
        return new BulkWriterContextFactory();
    }
}

