/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.data.partitioner.Partitioner;

public class TokenUtils
implements Serializable {
    private final String[] partitionKeyColumns;
    private final boolean isMurmur3Partitioner;
    private final ColumnType[] partitionKeyColumnTypes;

    public TokenUtils(List<String> partitionKeyColumns, List<ColumnType<?>> partitionKeyColumnTypes, boolean isMurmur3Partitioner) {
        this.partitionKeyColumns = partitionKeyColumns.toArray(new String[0]);
        this.partitionKeyColumnTypes = partitionKeyColumnTypes.toArray(new ColumnType[partitionKeyColumns.size()]);
        this.isMurmur3Partitioner = isMurmur3Partitioner;
    }

    private ByteBuffer getByteBuffer(Object columnValue, int partitionKeyColumnIdx) {
        ColumnType columnType = this.partitionKeyColumnTypes[partitionKeyColumnIdx];
        if (columnType == ColumnTypes.UUID) {
            return columnType.serialize(UUID.fromString((String)columnValue));
        }
        return columnType.serialize(columnValue);
    }

    private BigInteger getToken(ByteBuffer[] byteBuffers) {
        return this.getToken(this.getCompositeKey(byteBuffers));
    }

    public BigInteger getToken(ByteBuffer key) {
        return this.isMurmur3Partitioner ? Partitioner.Murmur3Partitioner.hash(key) : Partitioner.RandomPartitioner.hash(key);
    }

    public ByteBuffer getCompositeKey(Object[] columnValues) {
        ByteBuffer[] byteBuffers = new ByteBuffer[this.partitionKeyColumns.length];
        for (int column = 0; column < this.partitionKeyColumns.length; ++column) {
            byteBuffers[column] = this.getByteBuffer(columnValues[column], column);
        }
        return this.getCompositeKey(byteBuffers);
    }

    public ByteBuffer getCompositeKey(ByteBuffer[] byteBuffers) {
        ByteBuffer key;
        if (byteBuffers.length == 1) {
            key = byteBuffers[0];
        } else {
            int length = 0;
            for (ByteBuffer buffer : byteBuffers) {
                length += 2;
                length += buffer.remaining();
                ++length;
            }
            key = ByteBuffer.allocate(length);
            for (ByteBuffer buffer : byteBuffers) {
                key.putShort((short)buffer.remaining());
                key.put(buffer);
                key.put((byte)0);
            }
            ((Buffer)key).flip();
        }
        return key;
    }

    public BigInteger getToken(Map<String, Object> columnValues) {
        ByteBuffer[] byteBuffers = new ByteBuffer[this.partitionKeyColumns.length];
        for (int column = 0; column < this.partitionKeyColumns.length; ++column) {
            byteBuffers[column] = this.getByteBuffer(columnValues.get(this.partitionKeyColumns[column]), column);
        }
        return this.getToken(byteBuffers);
    }

    public BigInteger getToken(List<Object> columnValues) {
        return this.getToken(columnValues.toArray());
    }

    public BigInteger getToken(Object[] columnValues) {
        return this.getToken(this.getCompositeKey(columnValues));
    }
}

