/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.common.Digest;

public interface SSTableCollector {
    public void includeDirectory(Path var1);

    public void includeSSTable(List<Path> var1);

    public void includeFileDigests(Map<Path, Digest> var1);

    public Map<Path, Digest> fileDigests(Set<Path> var1);

    public long totalSize();

    public SSTableFilesAndRange peek();

    public SSTableFilesAndRange consumeOne();

    public boolean isEmpty();

    public static class SSTableFilesAndRange {
        public final Set<Path> files;
        public final SSTableSummary summary;
        public final long size;

        public SSTableFilesAndRange(SSTableSummary summary, List<Path> components, long size) {
            this.summary = summary;
            this.files = Collections.unmodifiableSet(new HashSet<Path>(components));
            this.size = size;
        }
    }
}

