/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.DirectStreamSession;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SidecarDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.jetbrains.annotations.NotNull;

public class CassandraDirectDataTransportContext
implements TransportContext.DirectDataBulkWriterContext {
    @NotNull
    private final JobInfo jobInfo;
    @NotNull
    private final ClusterInfo clusterInfo;
    @NotNull
    private final DirectDataTransferApi dataTransferApi;

    public CassandraDirectDataTransportContext(@NotNull BulkWriterContext bulkWriterContext) {
        this.jobInfo = bulkWriterContext.job();
        this.clusterInfo = bulkWriterContext.cluster();
        this.dataTransferApi = this.createDirectDataTransferApi();
    }

    public DirectStreamSession createStreamSession(BulkWriterContext writerContext, String sessionId, SortedSSTableWriter sstableWriter, Range<BigInteger> range, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
        return new DirectStreamSession(writerContext, sstableWriter, this, sessionId, range, failureHandler, executorService);
    }

    @Override
    public DirectDataTransferApi dataTransferApi() {
        return this.dataTransferApi;
    }

    protected DirectDataTransferApi createDirectDataTransferApi() {
        CassandraBridge bridge = CassandraBridgeFactory.get(this.clusterInfo.getLowestCassandraVersion());
        return new SidecarDataTransferApi(this.clusterInfo.getCassandraContext(), bridge, this.jobInfo);
    }
}

