/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.io.Serializable;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.SchemaInfo;
import org.jetbrains.annotations.NotNull;

public final class BroadcastableSchemaInfo
implements Serializable {
    private static final long serialVersionUID = -8727074052066841748L;
    private final BroadcastableTableSchema broadcastableTableSchema;
    private final Set<String> userDefinedTypeStatements;

    public static BroadcastableSchemaInfo from(@NotNull SchemaInfo source) {
        return new BroadcastableSchemaInfo(BroadcastableTableSchema.from(source.getTableSchema()), source.getUserDefinedTypeStatements());
    }

    private BroadcastableSchemaInfo(BroadcastableTableSchema broadcastableTableSchema, Set<String> userDefinedTypeStatements) {
        this.broadcastableTableSchema = broadcastableTableSchema;
        this.userDefinedTypeStatements = userDefinedTypeStatements;
    }

    public BroadcastableTableSchema getBroadcastableTableSchema() {
        return this.broadcastableTableSchema;
    }

    @NotNull
    public Set<String> getUserDefinedTypeStatements() {
        return this.userDefinedTypeStatements;
    }
}

