/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.IBroadcastableClusterInfo;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BroadcastableClusterInfo
implements IBroadcastableClusterInfo {
    private static final long serialVersionUID = 4506917240637924802L;
    private final Partitioner partitioner;
    private final String cassandraVersion;
    private final String clusterId;
    private final BulkSparkConf conf;

    public static BroadcastableClusterInfo from(@NotNull ClusterInfo source, @NotNull BulkSparkConf conf) {
        return new BroadcastableClusterInfo(source.getPartitioner(), source.getLowestCassandraVersion(), source.clusterId(), conf);
    }

    private BroadcastableClusterInfo(@NotNull Partitioner partitioner, @NotNull String cassandraVersion, @Nullable String clusterId, @NotNull BulkSparkConf conf) {
        this.partitioner = partitioner;
        this.cassandraVersion = cassandraVersion;
        this.clusterId = clusterId;
        this.conf = conf;
    }

    @Override
    public BulkSparkConf getConf() {
        return this.conf;
    }

    @Override
    public String getLowestCassandraVersion() {
        return this.cassandraVersion;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    @Override
    @Nullable
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public ClusterInfo reconstruct() {
        return new CassandraClusterInfo(this);
    }
}

