/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.reader.common;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.reader.IndexConsumer;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.reader.common.IIndexReader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexIterator<ReaderType extends IIndexReader>
implements StreamScanner<IndexEntry>,
IndexConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexIterator.class);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final Set<ReaderType> readers;
    private final LinkedBlockingQueue<IndexEntry> queue = new LinkedBlockingQueue();
    private final long startTimeNanos;
    private final Stats stats;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private IndexEntry curr = null;

    public IndexIterator(@NotNull SSTablesSupplier ssTables, @NotNull Stats stats, @NotNull IndexReaderOpener<ReaderType> supplier) {
        this.startTimeNanos = System.nanoTime();
        this.stats = stats;
        this.readers = ssTables.openAll((ssTable, isRepairPrimary) -> supplier.openReader(ssTable, isRepairPrimary, this));
        stats.openedIndexFiles(System.nanoTime() - this.startTimeNanos);
    }

    public void accept(IndexEntry wrapper) {
        if (this.closed.get()) {
            return;
        }
        try {
            this.queue.put(wrapper);
            this.stats.indexEntryConsumed();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public IndexEntry data() {
        return Objects.requireNonNull(this.curr, "advanceToNextColumn() must be called before data()");
    }

    public boolean next() throws IOException {
        return this.isRunning() && this.noFailures() && (this.hasPendingItems() || this.notFinished());
    }

    protected boolean isRunning() {
        return !this.closed.get();
    }

    protected boolean hasPendingItems() {
        return !this.queue.isEmpty();
    }

    protected boolean noFailures() {
        return !this.maybeFail();
    }

    protected boolean maybeFail() {
        Throwable t = this.failure.get();
        if (t != null) {
            throw new RuntimeException(t);
        }
        return false;
    }

    private boolean notFinished() {
        return !this.isFinished();
    }

    private boolean isFinished() {
        return this.finished.get() == this.readers.size();
    }

    public boolean hasMoreColumns() {
        return true;
    }

    public void advanceToNextColumn() {
        if (this.closed.get()) {
            throw new IllegalStateException("Iterator closed");
        }
        try {
            long startTimeNanos = System.nanoTime();
            this.curr = this.queue.take();
            this.stats.indexIteratorTimeBlocked(System.nanoTime() - startTimeNanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.closed.get() && this.closed.compareAndSet(false, true)) {
            this.queue.clear();
            this.stats.closedIndexIterator(System.nanoTime() - this.startTimeNanos);
        }
    }

    public void onFailure(Throwable t) {
        LOGGER.warn("IndexReader failed with exception", t);
        this.stats.indexReaderFailure(t);
        if (this.failure.get() == null) {
            this.failure.compareAndSet(null, t);
        }
    }

    public void onFinished(long runtimeNanos) {
        this.stats.indexReaderFinished(runtimeNanos);
        this.finished.incrementAndGet();
    }

    public static interface IndexReaderOpener<ReaderType extends IIndexReader> {
        public ReaderType openReader(SSTable var1, boolean var2, IndexConsumer var3) throws IOException;
    }
}

